"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoDiscover = exports.LambdaAutoDiscover = exports.IntegrationTestAutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_1 = require("../cdk");
const component_1 = require("../component");
const integration_test_1 = require("./integration-test");
const internal_1 = require("./internal");
const lambda_function_1 = require("./lambda-function");
/**
 * Creates integration tests from entry points discovered in the test tree.
 */
class IntegrationTestAutoDiscover extends cdk_1.IntegrationTestAutoDiscoverBase {
    constructor(project, options) {
        super(project, options);
        for (const entrypoint of this.entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                ...options.integrationTestOptions,
            });
        }
    }
}
exports.IntegrationTestAutoDiscover = IntegrationTestAutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscover[_a] = { fqn: "projen.awscdk.IntegrationTestAutoDiscover", version: "0.52.53" };
/**
 * Creates lambdas from entry points discovered in the project's source tree.
 */
class LambdaAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_LAMBDA_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaOptions,
            });
        }
    }
}
exports.LambdaAutoDiscover = LambdaAutoDiscover;
_b = JSII_RTTI_SYMBOL_1;
LambdaAutoDiscover[_b] = { fqn: "projen.awscdk.LambdaAutoDiscover", version: "0.52.53" };
/**
 * Discovers and creates integration tests and lambdas from code in the
 * project's source and test trees.
 */
class AutoDiscover extends component_1.Component {
    constructor(project, options) {
        var _d, _e;
        super(project);
        if ((_d = options.lambdaAutoDiscover) !== null && _d !== void 0 ? _d : true) {
            new LambdaAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaOptions: options.lambdaOptions,
            });
        }
        if ((_e = options.integrationTestAutoDiscover) !== null && _e !== void 0 ? _e : true) {
            new IntegrationTestAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                testdir: options.testdir,
                tsconfigPath: options.tsconfigPath,
                integrationTestOptions: options.integrationTestOptions,
            });
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_c = JSII_RTTI_SYMBOL_1;
AutoDiscover[_c] = { fqn: "projen.awscdk.AutoDiscover", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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