"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkJavaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const __1 = require("..");
const java_1 = require("../java");
const awscdk_deps_java_1 = require("./awscdk-deps-java");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
/**
 * AWS CDK app in Java.
 *
 * @pjid awscdk-app-java
 */
class AwsCdkJavaApp extends java_1.JavaProject {
    constructor(options) {
        var _b;
        const mainClassComponents = options.mainClass.split(".");
        const mainPackage = mainClassComponents.slice(0, -1);
        const mainClassName = mainClassComponents[mainClassComponents.length - 1];
        super({
            ...options,
            sample: false,
            sampleJavaPackage: mainPackage.join("."),
        });
        this.mainClass = options.mainClass;
        this.mainPackage = mainPackage.join(".");
        this.mainClassName = mainClassName;
        this.cdkDeps = new awscdk_deps_java_1.AwsCdkDepsJava(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synth);
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `mvn exec:java --quiet -Dexec.mainClass=${this.mainClass}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            ...options,
        });
        if ((_b = options.sample) !== null && _b !== void 0 ? _b : true) {
            this.addSample();
        }
    }
    /**
     * Adds an AWS CDK module dependencies
     *
     * @param modules The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc)
     * @deprecated In CDK 2.x all modules are available by default. Alpha modules should be added using the standard 'deps'
     */
    addCdkDependency(...modules) {
        for (const m of modules) {
            this.cdkDeps.addV1Dependencies(m);
        }
    }
    addSample() {
        const pkg = this.mainPackage.split(".");
        const javaFile = `${this.mainClassName}.java`;
        new __1.SampleDir(this, path_1.join("src", "main", "java", ...pkg), {
            files: {
                [javaFile]: [
                    `package ${pkg.join(".")};`,
                    "",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.App;"
                        : "import software.amazon.awscdk.App;",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.Stack;"
                        : "import software.amazon.awscdk.Stack;",
                    "",
                    `public class ${this.mainClassName} {`,
                    "  public static void main(final String[] args) {",
                    "    App app = new App();",
                    '    new Stack(app, "MyStack");',
                    "    app.synth();",
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.AwsCdkJavaApp = AwsCdkJavaApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkJavaApp[_a] = { fqn: "projen.awscdk.AwsCdkJavaApp", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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