"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const __1 = require("..");
const pytest_1 = require("../python/pytest");
const python_project_1 = require("../python/python-project");
const awscdk_deps_py_1 = require("./awscdk-deps-py");
const awscdk_pytest_sample_1 = require("./awscdk-pytest-sample");
/**
 * AWS CDK app in Python
 *
 * @pjid awscdk-app-py
 */
class AwsCdkPythonApp extends python_project_1.PythonProject {
    constructor(options) {
        var _b, _c, _d, _e;
        super({ ...options, pytest: false, sample: false });
        this.cdkDeps = new awscdk_deps_py_1.AwsCdkDepsPy(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : "app.py";
        this.testdir = (_c = options.testdir) !== null && _c !== void 0 ? _c : "tests";
        this.cdkTasks = new _1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synthSilent);
        this.cdkConfig = new _1.CdkConfig(this, {
            app: `python ${this.appEntrypoint}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            watchIncludes: ["**"],
            watchExcludes: [
                "README.md",
                "cdk*.json",
                "requirements*.txt",
                "source.bat",
                "**/__init__.py",
                "python/__pycache__",
                "tests",
            ],
            ...options,
        });
        if ((_d = options.sample) !== null && _d !== void 0 ? _d : true) {
            new AppCode(this, "app.py", this.cdkDeps.cdkMajorVersion);
            new MyStackCode(this, this.moduleName, this.cdkDeps.cdkMajorVersion);
        }
        if ((_e = options.pytest) !== null && _e !== void 0 ? _e : true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
            new awscdk_pytest_sample_1.AwsCdkPytestSample(this, this.pytest.testdir);
        }
    }
    /**
     * The CDK version this app is using.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
}
exports.AwsCdkPythonApp = AwsCdkPythonApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkPythonApp[_a] = { fqn: "projen.awscdk.AwsCdkPythonApp", version: "0.52.53" };
class AppCode extends __1.Component {
    constructor(project, fileName, cdkVersion) {
        super(project);
        const src = new __1.SourceCode(project, fileName);
        src.line("import os");
        if (cdkVersion < 2) {
            src.line("from aws_cdk.core import App, Environment");
        }
        else {
            src.line("from aws_cdk import App, Environment");
        }
        src.line(`from ${project.moduleName}.my_stack import MyStack`);
        src.line("");
        src.line("# for development, use account/region from cdk cli");
        src.open("dev_env = Environment(");
        src.line("account=os.getenv('CDK_DEFAULT_ACCOUNT'),");
        src.line("region=os.getenv('CDK_DEFAULT_REGION'),");
        src.close(")");
        src.line("");
        src.line("app = App()");
        src.line('MyStack(app, "my-stack-dev", env=dev_env)');
        src.line('# MyStack(app, "my-stack-prod", env=prod_env)');
        src.line("");
        src.line("app.synth()");
    }
}
class MyStackCode extends __1.Component {
    constructor(project, sampleFile, cdkMajorVersion) {
        super(project);
        let appFile = [];
        appFile.push("import os");
        if (cdkMajorVersion < 2) {
            appFile.push("from aws_cdk.core import Construct, Stack");
        }
        else {
            appFile.push("from aws_cdk import Stack");
            appFile.push("from constructs import Construct");
        }
        appFile.push("");
        appFile.push("");
        appFile.push("class MyStack(Stack):");
        appFile.push("");
        appFile.push("  def __init__(self, scope: Construct, construct_id: str, **kwargs) -> None:");
        appFile.push("    super().__init__(scope, construct_id, **kwargs)");
        appFile.push("");
        appFile.push("    # The code that defines your stack goes here");
        appFile.push("");
        new __1.SampleDir(project, sampleFile, {
            files: {
                "__init__.py": "",
                "my_stack.py": appFile.join("\n"),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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