"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_js_1 = require("./awscdk-deps-js");
/**
 * AWS CDK construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    constructor(options) {
        var _c, _d, _e;
        const cdkMajorVersion = (_c = semver.parse(options.cdkVersion)) === null || _c === void 0 ? void 0 : _c.major;
        super({
            peerDependencyOptions: cdkMajorVersion === 1
                ? {
                    pinnedDevDependency: false,
                }
                : undefined,
            workflowContainerImage: determineWorkflowContainerImage(options, cdkMajorVersion),
            ...options,
        });
        this.cdkDeps = new awscdk_deps_js_1.AwsCdkDepsJs(this, {
            // since this we are a library, dependencies should be added a peers
            dependencyType: dependencies_1.DependencyType.PEER,
            ...options,
        });
        new auto_discover_1.AutoDiscover(this, {
            srcdir: this.srcdir,
            testdir: this.testdir,
            lambdaOptions: options.lambdaOptions,
            tsconfigPath: this.tsconfigDev.fileName,
            cdkDeps: this.cdkDeps,
            lambdaAutoDiscover: (_d = options.lambdaAutoDiscover) !== null && _d !== void 0 ? _d : true,
            integrationTestAutoDiscover: (_e = options.integrationTestAutoDiscover) !== null && _e !== void 0 ? _e : true,
        });
    }
    /**
     * The target CDK version for this library.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps) {
        return this.cdkDeps.addV1Dependencies(...deps);
    }
    /**
     * Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps) {
        return this.cdkDeps.addV1DevDependencies(...deps);
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.52.53" };
function determineWorkflowContainerImage(options, cdkMajorVersion) {
    // if the user specifies the workflow container image explicitly, use that
    if (options.workflowContainerImage) {
        return options.workflowContainerImage;
    }
    // if the user specifies minimum node version, then JsiiProject will take care of
    // determining the workflow container image from that, so we return "undefined"
    if (options.minNodeVersion) {
        return undefined;
    }
    // otherwise, choose a workflow container image based on the CDK version
    if (cdkMajorVersion === 1) {
        return "jsii/superchain:1-buster-slim";
    }
    if (cdkMajorVersion === 2) {
        return "jsii/superchain:1-buster-slim-node14";
    }
    return undefined;
}
/** @deprecated use `AwsCdkConstructLibrary` */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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