import { Component } from "../component";
import { DependencyType } from "../dependencies";
import { Project } from "../project";
/**
 * Options for `AwsCdkDeps`
 */
export interface AwsCdkDepsCommonOptions {
    /**
     * Minimum version of the AWS CDK to depend on.
     *
     * @default "2.1.0"
     */
    readonly cdkVersion: string;
    /**
     * Minimum version of the `constructs` library to depend on.
     *
     * @default - for CDK 1.x the default is "3.2.27", for CDK 2.x the default is
     * "10.0.5".
     */
    readonly constructsVersion?: string;
    /**
     * Use pinned version instead of caret version for CDK.
     *
     * You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     */
    readonly cdkVersionPinning?: boolean;
    /**
     * Which AWS CDKv1 modules this project requires
     *
     * @deprecated For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)
     */
    readonly cdkDependencies?: string[];
    /**
     * If this is enabled (default), all modules declared in `cdkDependencies` will be also added as
     * normal `dependencies` (as well as `peerDependencies`).
     *
     * This is to ensure that downstream consumers actually have your CDK dependencies installed
     * when using npm < 7 or yarn, where peer dependencies are not automatically installed.
     * If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
     * they are present during development.
     *
     * Note: this setting only applies to construct library projects
     *
     * @default true
     * @deprecated Not supported in CDK v2.
     */
    readonly cdkDependenciesAsDeps?: boolean;
    /**
     * Warning: NodeJS only.
     * Install the @aws-cdk/assert library?
     *
     * @default - will be included by default for AWS CDK >= 1.0.0 < 2.0.0
     * @deprecated The @aws-cdk/assert library is deprecated in favor of
     * @aws-cdk/assertions (in V1) and included in `aws-cdk-lib` for V2.
     */
    readonly cdkAssert?: boolean;
    /**
     * Install the assertions library?
     *
     * Only needed for CDK 1.x. If using CDK 2.x then
     * assertions is already included in 'aws-cdk-lib'
     *
     * @default - will be included by default for AWS CDK >= 1.111.0 < 2.0.0
     */
    readonly cdkAssertions?: boolean;
    /**
     * AWS CDK modules required for testing.
     *
     * @deprecated For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead
     */
    readonly cdkTestDependencies?: string[];
}
export interface AwsCdkDepsOptions extends AwsCdkDepsCommonOptions {
    /**
     * The type of dependency to use for runtime AWS CDK and `constructs` modules.
     *
     * For libraries, use peer dependencies and for apps use runtime dependencies.
     */
    readonly dependencyType: DependencyType;
}
/**
 * Language-specific AWS CDK package names.
 */
export interface AwsCdkPackageNames {
    /**
     * Fully qualified name of the core framework package for CDKv1
     */
    readonly coreV1: string;
    /**
     * Fully qualified name of the core framework package for CDKv2
     */
    readonly coreV2: string;
    /**
     * Fully qualified name of the constructs library package
     */
    readonly constructs: string;
    /**
     * Fully qualified name of the assertions library package
     */
    readonly assertions: string;
    /**
     * Fully qualified name of the assert library package
     * Can be empty as it's only really available for javascript projects
     */
    readonly assert?: string;
}
/**
 * Manages dependencies on the AWS CDK.
 */
export declare abstract class AwsCdkDeps extends Component {
    /**
     * The dependency requirement for AWS CDK (e.g. `^2.0.0`).
     */
    readonly cdkVersion: string;
    /**
     * The minimum version of the AWS CDK (e.g. `2.0.0`).
     */
    readonly cdkMinimumVersion: string;
    /**
     * Whether CDK dependencies are added as normal dependencies (and peer dependencies).
     * @deprecated Not used for CDK 2.x
     */
    readonly cdkDependenciesAsDeps: boolean;
    /**
     * The major version of the AWS CDK (e.g. 1, 2, ...)
     */
    readonly cdkMajorVersion: number;
    private readonly dependencyType;
    private readonly _packageNames;
    constructor(project: Project, options: AwsCdkDepsOptions);
    /**
     * Adds dependencies to AWS CDK modules.
     *
     * The type of dependency is determined by the `dependencyType` option.
     *
     * This method is not supported in CDK v2. Use `project.addPeerDeps()` or
     * `project.addDeps()` as appropriate.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     */
    addV1Dependencies(...deps: string[]): void;
    /**
     * Adds AWS CDK modules as dev dependencies.
     *
     * This method is not supported in CDK v2. Use `project.addPeerDeps()` or
     * `project.addDeps()` as appropriate.
     *
     * @param deps fully qualified names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     */
    addV1DevDependencies(...deps: string[]): void;
    private addConstructsDependency;
    /**
     * Adds a dependency on the AWS CDK framework (e.g. `@aws-cdk/core` for V1 or `aws-cdk-lib` for V1).
     */
    private addFrameworkDependency;
    private addV1AssertionLibraryDependency;
    /**
     * Adds a set of dependencies with the user-specified dependency type.
     * @param deps The set of dependency specifications
     */
    private addV1DependenciesByType;
    /**
     * Return a configuration object with information about package naming in various languages
     */
    protected abstract packageNames(): AwsCdkPackageNames;
}
