"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalLevel = exports.CdkConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
const internal_1 = require("./internal");
/**
 * Represents cdk.json file.
 */
class CdkConfig extends component_1.Component {
    constructor(project, options) {
        var _b, _c, _d, _e;
        super(project);
        this.cdkout = (_b = options.cdkout) !== null && _b !== void 0 ? _b : "cdk.out";
        const context = { ...options.context };
        const fflags = (_c = options.featureFlags) !== null && _c !== void 0 ? _c : true;
        if (fflags) {
            for (const flag of internal_1.FEATURE_FLAGS) {
                context[flag] = true;
            }
        }
        this.json = new json_1.JsonFile(project, "cdk.json", {
            omitEmpty: true,
            obj: {
                app: options.app,
                context: context,
                requireApproval: options.requireApproval,
                output: this.cdkout,
                build: options.buildCommand,
                watch: {
                    include: (_d = options.watchIncludes) !== null && _d !== void 0 ? _d : [],
                    exclude: (_e = options.watchExcludes) !== null && _e !== void 0 ? _e : [],
                },
            },
        });
        project.gitignore.exclude(`/${this.cdkout}/`);
        project.gitignore.exclude(".cdk.staging/");
    }
}
exports.CdkConfig = CdkConfig;
_a = JSII_RTTI_SYMBOL_1;
CdkConfig[_a] = { fqn: "projen.awscdk.CdkConfig", version: "0.52.53" };
/**
 * Which approval is required when deploying CDK apps.
 */
var ApprovalLevel;
(function (ApprovalLevel) {
    /**
     * Approval is never required
     */
    ApprovalLevel["NEVER"] = "never";
    /**
     * Requires approval on any IAM or security-group-related change
     */
    ApprovalLevel["ANY_CHANGE"] = "any-change";
    /**
     * Requires approval when IAM statements or traffic rules are added; removals don't require approval
     */
    ApprovalLevel["BROADENING"] = "broadening";
})(ApprovalLevel = exports.ApprovalLevel || (exports.ApprovalLevel = {}));
//# sourceMappingURL=data:application/json;base64,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