"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkTasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Adds standard AWS CDK tasks to your project.
 */
class CdkTasks extends component_1.Component {
    constructor(project) {
        var _b;
        super(project);
        this.synth = project.addTask("synth", {
            description: "Synthesizes your cdk app into cdk.out",
            exec: "cdk synth",
        });
        this.synthSilent = project.addTask("synth:silent", {
            description: 'Synthesizes your cdk app into cdk.out and suppresses the template in stdout (part of "yarn build")',
            exec: "cdk synth > /dev/null",
        });
        this.deploy = project.addTask("deploy", {
            description: "Deploys your CDK app to the AWS cloud",
            exec: "cdk deploy",
        });
        this.destroy = project.addTask("destroy", {
            description: "Destroys your cdk app in the AWS cloud",
            exec: "cdk destroy",
        });
        this.diff = project.addTask("diff", {
            description: "Diffs the currently deployed app against your code",
            exec: "cdk diff",
        });
        // typescript projects already have a "watch" task, we we will repurpose it
        const watch = (_b = project.tasks.tryFind("watch")) !== null && _b !== void 0 ? _b : project.addTask("watch");
        watch.reset();
        watch.description =
            "Watches changes in your source code and rebuilds and deploys to the current account";
        // deploy first because surprisingly watch is not deploying first
        // see https://github.com/aws/aws-cdk/issues/17776
        watch.exec("cdk deploy --hotswap");
        // now we are ready to watch
        watch.exec("cdk watch");
        this.watch = watch;
    }
}
exports.CdkTasks = CdkTasks;
_a = JSII_RTTI_SYMBOL_1;
CdkTasks[_a] = { fqn: "projen.awscdk.CdkTasks", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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