"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
const internal_1 = require("./internal");
/**
 * Cloud integration tests.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        var _b, _c, _d;
        super(project, options);
        if (!project.deps.tryGetDependency("aws-cdk")) {
            project.deps.addDependency(`aws-cdk@^${options.cdkDeps.cdkMajorVersion}`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = path_1.join(this.tmpDir, "deploy.cdk.out");
        const assertDir = path_1.join(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        const opts = [
            `--app "${app}"`,
            "--no-version-reporting",
            // don't inject cloudformation metadata into template
            "--no-asset-metadata",
        ];
        const pathMetadata = (_b = options.pathMetadata) !== null && _b !== void 0 ? _b : false;
        if (!pathMetadata) {
            opts.push("--no-path-metadata");
        }
        if (options.cdkDeps.cdkMajorVersion === 1) {
            // add all feature flags
            const features = [
                ...internal_1.FEATURE_FLAGS,
                "@aws-cdk/core:newStyleStackSynthesis",
            ];
            for (const feature of features) {
                opts.push(`--context ${feature}=true`);
            }
        }
        const cdkopts = opts.join(" ");
        // Determine which stacks to deploy
        const stacks = (_c = options.stacks) !== null && _c !== void 0 ? _c : ["**"];
        const stackOpts = stacks.map((stack) => `'${stack}'`).join(" ");
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk deploy ${cdkopts} ${stackOpts} --require-approval=never -o ${deployDir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        this.watchTask = project.addTask(`integ:${this.name}:watch`, {
            description: `watch integration test '${this.name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} ${stackOpts} -o ${deployDir}`,
        });
        this.destroyTask = project.addTask(`integ:${this.name}:destroy`, {
            description: `destroy integration test '${this.name}'`,
            exec: `cdk destroy --app ${this.snapshotDir} ${stackOpts} --no-version-reporting`,
        });
        const destroyAfterDeploy = (_d = options.destroyAfterDeploy) !== null && _d !== void 0 ? _d : true;
        if (destroyAfterDeploy) {
            this.deployTask.spawn(this.destroyTask);
        }
        this.snapshotTask.exec(`cdk synth ${cdkopts} -o ${this.snapshotDir} > /dev/null`);
        const exclude = ["asset.*", "cdk.out", "manifest.json", "tree.json"];
        this.assertTask.exec(`cdk synth ${cdkopts} -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff -r ${exclude.map((x) => `-x ${x}`).join(" ")} ${this.snapshotDir}/ ${assertDir}/`);
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${this.snapshotDir}/${x}`);
            project.addGitIgnore(`${this.snapshotDir}/**/${x}`); // nested assemblies
        }
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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