"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiDocgen = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Creates a markdown file based on the jsii manifest:
 * - Adds a `docgen` script to package.json
 * - Runs `jsii-docgen` after compilation
 * - Enforces that markdown file is checked in
 */
class JsiiDocgen {
    constructor(project, options = {}) {
        var _b;
        project.addDevDeps("jsii-docgen");
        const filePath = (_b = options.filePath) !== null && _b !== void 0 ? _b : "API.md";
        const docgen = project.addTask("docgen", {
            description: "Generate API.md from .jsii manifest",
            exec: `jsii-docgen -o ${filePath}`,
        });
        // spawn docgen after compilation (requires the .jsii manifest).
        project.postCompileTask.spawn(docgen);
        project.gitignore.include(`/${filePath}`);
    }
}
exports.JsiiDocgen = JsiiDocgen;
_a = JSII_RTTI_SYMBOL_1;
JsiiDocgen[_a] = { fqn: "projen.cdk.JsiiDocgen", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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