"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const typescript_1 = require("../typescript");
const consts_1 = require("./consts");
const jsii_docgen_1 = require("./jsii-docgen");
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
const REPO_TEMP_DIRECTORY = ".repo";
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * Multi-language jsii library project
 *
 * @pjid jsii
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            repository: options.repositoryUrl,
            authorName: options.author,
            authorEmail,
            authorUrl,
            ...options,
            releaseToNpm: false,
            disableTsconfig: true,
            docgen: false,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            "--silence-warnings=reserved-word",
            "--no-fix-peer-dependencies",
        ].join(" ");
        const compatIgnore = (_b = options.compatIgnore) !== null && _b !== void 0 ? _b : ".compatignore";
        this.addFields({ stability: (_c = options.stability) !== null && _c !== void 0 ? _c : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask("compat", {
            description: "Perform API compatibility check against latest version",
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_d = options.compat) !== null && _d !== void 0 ? _d : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        this.packageAllTask = this.addTask("package-all", {
            description: "Packages artifacts for all target languages",
        });
        // in jsii we consider the entire repo (post build) as the build artifact
        // which is then used to create the language bindings in separate jobs.
        const prepareRepoForCI = [
            `mkdir -p ${this.artifactsDirectory}`,
            `rsync -a . ${this.artifactsDirectory} --exclude .git --exclude node_modules`,
        ].join(" && ");
        // when running inside CI we just prepare the repo for packaging, which
        // takes place in separate tasks.
        // outside of CI (i.e locally) we simply package all targets.
        this.packageTask.reset(`if [ ! -z \${CI} ]; then ${prepareRepoForCI}; else ${this.runTaskCommand(this.packageAllTask)}; fi`);
        const targets = {};
        const jsii = {
            outdir: this.artifactsDirectory,
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        (_e = this.release) === null || _e === void 0 ? void 0 : _e.publisher.addGitHubPrePublishingSteps({
            name: "Prepare Repository",
            run: `mv ${this.artifactsDirectory} ${REPO_TEMP_DIRECTORY}`,
        }, {
            name: "Collect GitHub Metadata",
            run: `mv ${REPO_TEMP_DIRECTORY}/${this.artifactsDirectory} ${this.artifactsDirectory}`,
        });
        if (options.releaseToNpm != false) {
            const task = this.addPackagingTask("js");
            (_f = this.release) === null || _f === void 0 ? void 0 : _f.publisher.publishToNpm({
                ...this.pacmakForLanguage("js", task),
                registry: this.package.npmRegistry,
                npmTokenSecret: this.package.npmTokenSecret,
            });
            this.addPackagingTarget("js", task);
        }
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ("java" in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            const task = this.addPackagingTask("java");
            (_g = this.release) === null || _g === void 0 ? void 0 : _g.publisher.publishToMaven({
                ...this.pacmakForLanguage("java", task),
                ...options.publishToMaven,
            });
            this.addPackagingTarget("java", task);
        }
        const pypi = (_h = options.publishToPypi) !== null && _h !== void 0 ? _h : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            const task = this.addPackagingTask("python");
            (_j = this.release) === null || _j === void 0 ? void 0 : _j.publisher.publishToPyPi({
                ...this.pacmakForLanguage("python", task),
                ...pypi,
            });
            this.addPackagingTarget("python", task);
        }
        const nuget = (_k = options.publishToNuget) !== null && _k !== void 0 ? _k : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            const task = this.addPackagingTask("dotnet");
            (_l = this.release) === null || _l === void 0 ? void 0 : _l.publisher.publishToNuget({
                ...this.pacmakForLanguage("dotnet", task),
                ...nuget,
            });
            this.addPackagingTarget("dotnet", task);
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            const task = this.addPackagingTask("go");
            (_m = this.release) === null || _m === void 0 ? void 0 : _m.publisher.publishToGo({
                ...this.pacmakForLanguage("go", task),
                ...golang,
            });
            this.addPackagingTarget("go", task);
        }
        this.addDevDeps("jsii", "jsii-diff");
        this.gitignore.exclude(".jsii", "tsconfig.json");
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.include(".jsii");
        if ((_p = options.docgen) !== null && _p !== void 0 ? _p : true) {
            new jsii_docgen_1.JsiiDocgen(this, { filePath: options.docgenFilePath });
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
    }
    /**
     * Adds a target language to the build workflow and creates a package task.
     * @param language
     * @returns
     */
    addPackagingTarget(language, packTask) {
        var _b;
        if (!this.buildWorkflow) {
            return;
        }
        const pacmak = this.pacmakForLanguage(language, packTask);
        this.buildWorkflow.addPostBuildJob(`package-${language}`, {
            runsOn: ["ubuntu-latest"],
            permissions: {},
            tools: {
                node: { version: "14.x" },
                ...pacmak.publishTools,
            },
            steps: (_b = pacmak.prePublishSteps) !== null && _b !== void 0 ? _b : [],
        });
    }
    addPackagingTask(language) {
        const packageTask = this.tasks.addTask(`package:${language}`, {
            description: `Create ${language} language bindings`,
        });
        packageTask.exec("jsii_version=$(node -p \"JSON.parse(fs.readFileSync('.jsii')).jsiiVersion.split(' ')[0]\")");
        packageTask.exec(`npx jsii-pacmak@$jsii_version -v --target ${language}`);
        this.packageAllTask.spawn(packageTask);
        return packageTask;
    }
    pacmakForLanguage(target, packTask) {
        // at this stage, `artifactsDirectory` contains the prebuilt repository.
        // for the publishing to work seamlessely, that directory needs to contain the actual artifact.
        // so we move the repo, create the artifact, and put it in the expected place.
        return {
            publishTools: consts_1.JSII_TOOLCHAIN[target],
            prePublishSteps: [
                {
                    name: "Prepare Repository",
                    run: `mv ${this.artifactsDirectory} ${REPO_TEMP_DIRECTORY}`,
                },
                {
                    name: "Install Dependencies",
                    run: `cd ${REPO_TEMP_DIRECTORY} && ${this.package.installCommand}`,
                },
                {
                    name: `Create ${target} artifact`,
                    run: `cd ${REPO_TEMP_DIRECTORY} && npx projen ${packTask.name}`,
                },
                {
                    name: `Collect ${target} Artifact`,
                    run: `mv ${REPO_TEMP_DIRECTORY}/${this.artifactsDirectory} ${this.artifactsDirectory}`,
                },
            ],
        };
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.cdk.JsiiProject", version: "0.52.53" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error("authorEmail is deprecated and cannot be used in conjunction with authorAddress");
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error("authorUrl is deprecated and cannot be used in conjunction with authorAddress.");
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
//# sourceMappingURL=data:application/json;base64,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