"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestAutoDiscover = exports.AutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_1 = require("../cdk");
const component_1 = require("../component");
const integration_test_1 = require("./integration-test");
/**
 * Automatically discovers and creates `IntegrationTest`s from entry points
 * found in the test tree.
 */
class AutoDiscover extends component_1.Component {
    constructor(project, options) {
        var _c;
        super(project);
        if ((_c = options.integrationTestAutoDiscover) !== null && _c !== void 0 ? _c : true) {
            new IntegrationTestAutoDiscover(this.project, options);
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscover[_a] = { fqn: "projen.cdk8s.AutoDiscover", version: "0.52.53" };
/**
 * Discovers and creates integration tests from files in the test root.
 */
class IntegrationTestAutoDiscover extends cdk_1.IntegrationTestAutoDiscoverBase {
    constructor(project, options) {
        super(project, options);
        for (const entrypoint of this.entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint,
                tsconfigPath: options.tsconfigPath,
            });
        }
    }
}
exports.IntegrationTestAutoDiscover = IntegrationTestAutoDiscover;
_b = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscover[_b] = { fqn: "projen.cdk8s.IntegrationTestAutoDiscover", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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