import { TypeScriptAppProject, TypeScriptProjectOptions } from "../typescript";
export interface Cdk8sTypeScriptAppOptions extends TypeScriptProjectOptions {
    /**
     * Minimum target version this library is tested against.
     *
     * @default "1.0.0-beta.10"
     * @featured
     */
    readonly cdk8sVersion: string;
    /**
     * Import a specific Kubernetes spec version.
     *
     * @default - Use the cdk8s default
     */
    readonly k8sSpecVersion?: string;
    /**
     * Import additional specs
     *
     * @default - no additional specs imported
     */
    readonly cdk8sImports?: string[];
    /**
     * constructs verion
     *
     * @default "3.2.34"
     */
    readonly constructsVersion?: string;
    /**
     * cdk8s-cli version
     *
     * @default "cdk8sVersion"
     */
    readonly cdk8sCliVersion?: string;
    /**
     * Use pinned version instead of caret version for CDK8s.
     *
     * You can use this to prevent yarn to mix versions for your CDK8s package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     */
    readonly cdk8sVersionPinning?: boolean;
    /**
     * Use pinned version instead of caret version for CDK8s-cli.
     *
     * You can use this to prevent yarn to mix versions for your CDK8s package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     */
    readonly cdk8sCliVersionPinning?: boolean;
    /**
     * Use pinned version instead of caret version for cdk8s-plus-17.
     *
     * You can use this to prevent yarn to mix versions for your CDK8s package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     */
    readonly cdk8sPlusVersionPinning?: boolean;
    /**
     * Use pinned version instead of caret version for constructs.
     *
     * You can use this to prevent yarn to mix versions for your consructs package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     */
    readonly constructsVersionPinning?: boolean;
    /**
     * The CDK8s app's entrypoint (relative to the source directory, which is
     * "src" by default).
     *
     * @default "main.ts"
     */
    readonly appEntrypoint?: string;
    /**
     * Automatically adds an `cdk8s.IntegrationTest` for each `.integ.ts` app
     * in your test directory. If this is disabled, you can manually add an
     * `cdk8s.AutoDiscover` component to your project.
     *
     * @default true
     */
    readonly integrationTestAutoDiscover?: boolean;
}
/**
 * CDK8s app in TypeScript
 *
 *
 * @pjid cdk8s-app-ts
 */
export declare class Cdk8sTypeScriptApp extends TypeScriptAppProject {
    /**
     * The CDK8s version this app is using.
     */
    readonly cdk8sVersion: string;
    /**
     * The constructs version this app is using.
     */
    readonly constructsVersion: string;
    /**
     * The cdk8s-cli version this app is using.
     */
    readonly cdk8sCliVersion: string;
    /**
     * The CDK8s app entrypoint
     */
    readonly appEntrypoint: string;
    constructor(options: Cdk8sTypeScriptAppOptions);
}
