"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("../component");
const typescript_1 = require("../typescript");
const yaml_1 = require("../yaml");
const auto_discover_1 = require("./auto-discover");
/**
 * CDK8s app in TypeScript
 *
 *
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        var _b, _c, _d, _e;
        super({
            ...options,
            sampleCode: false,
        });
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        // encode a hidden assumption further down the chain
        if (this.srcdir !== "src") {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== "test") {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : "main.ts";
        this.cdk8sVersion = options.cdk8sVersionPinning
            ? options.cdk8sVersion
            : `^${options.cdk8sVersion}`;
        if (options.constructsVersion) {
            this.constructsVersion = options.constructsVersionPinning
                ? options.constructsVersion
                : `^${options.constructsVersion}`;
        }
        else {
            this.constructsVersion = "^3.2.34";
        }
        if (!!options.cdk8sCliVersion) {
            this.cdk8sCliVersion = options.cdk8sCliVersionPinning
                ? options.cdk8sCliVersion
                : `^${options.cdk8sCliVersion}`;
        }
        else {
            this.cdk8sCliVersion = this.cdk8sVersion;
        }
        // CLI
        this.addDeps(`cdk8s@${this.cdk8sVersion}`, `constructs@${this.constructsVersion}`);
        this.addDevDeps("ts-node@^9", `cdk8s-cli@${this.cdk8sCliVersion}`, `cdk8s@${this.cdk8sVersion}`, `constructs@${this.constructsVersion}`);
        const synth = this.addTask("synth", {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            exec: "cdk8s synth",
        });
        this.addTask("import", {
            description: "Imports API objects to your app by generating constructs.",
            exec: "cdk8s import -o src/imports",
        });
        // add synth to the build
        this.postCompileTask.spawn(synth);
        const cdk8sImports = (_c = options.cdk8sImports) !== null && _c !== void 0 ? _c : [];
        const k8sSpec = options.k8sSpecVersion
            ? `k8s@${options.k8sSpecVersion}`
            : "k8s";
        const appEntrypointBaseName = path.basename(this.appEntrypoint, ".ts");
        new yaml_1.YamlFile(this, "cdk8s.yaml", {
            committed: true,
            editGitignore: true,
            obj: {
                language: "typescript",
                app: `node lib/${appEntrypointBaseName}.js`,
                imports: [k8sSpec, ...cdk8sImports],
            },
        });
        if ((_d = options.sampleCode) !== null && _d !== void 0 ? _d : true) {
            new SampleCode(this);
        }
        new auto_discover_1.AutoDiscover(this, {
            testdir: this.testdir,
            tsconfigPath: this.tsconfigDev.fileName,
            integrationTestAutoDiscover: (_e = options.integrationTestAutoDiscover) !== null && _e !== void 0 ? _e : true,
        });
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.cdk8s.Cdk8sTypeScriptApp", version: "0.52.53" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) &&
            fs.readdirSync(srcdir).filter((x) => x.endsWith(".ts"))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
    }
}
//# sourceMappingURL=data:application/json;base64,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