"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdk8s = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
const auto_discover_1 = require("./auto-discover");
/**
 * CDK8s construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Kubernetes (CDK8s), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @pjid cdk8s-construct
 */
class ConstructLibraryCdk8s extends cdk_1.ConstructLibrary {
    constructor(options) {
        var _b, _c, _d;
        super(options);
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        const cdk8sVersion = semver.parse(options.cdk8sVersion);
        if (!cdk8sVersion) {
            throw new Error(`"cdk8sVersion" cannot be parsed as a semver version: ${options.cdk8sVersion}`);
        }
        this.cdk8sVersion = options.cdk8sVersionPinning
            ? options.cdk8sVersion
            : `^${options.cdk8sVersion}`;
        const defaultConstructsVersion = cdk8sVersion.major === 1 ? "3.3.196" : "10.0.0";
        const resolvedConstructsVersion = (_b = options.constructsVersion) !== null && _b !== void 0 ? _b : defaultConstructsVersion;
        const resolvedMajorConstructVersion = (_c = semver.parse(resolvedConstructsVersion)) === null || _c === void 0 ? void 0 : _c.major;
        if (!resolvedMajorConstructVersion) {
            throw new Error(`"constructsVersion" cannot be parsed as a semver version: ${options.constructsVersion}`);
        }
        switch (cdk8sVersion.major) {
            case 1:
                if (resolvedMajorConstructVersion !== 3) {
                    throw new Error("cdk8s 1.x requires constructs 3.x");
                }
                break;
            case 2:
                if (resolvedMajorConstructVersion !== 10) {
                    throw new Error("cdk8s 2.x requires constructs 10.x");
                }
                break;
        }
        this.constructsVersion = options.constructsVersionPinning
            ? resolvedConstructsVersion
            : `^${resolvedConstructsVersion}`;
        this.addPeerDeps(`constructs@${this.constructsVersion}`, `cdk8s@${this.cdk8sVersion}`);
        new auto_discover_1.AutoDiscover(this, {
            testdir: this.testdir,
            tsconfigPath: this.tsconfigDev.fileName,
            integrationTestAutoDiscover: (_d = options.integrationTestAutoDiscover) !== null && _d !== void 0 ? _d : true,
        });
    }
}
exports.ConstructLibraryCdk8s = ConstructLibraryCdk8s;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdk8s[_a] = { fqn: "projen.cdk8s.ConstructLibraryCdk8s", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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