"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryProcessMacro = void 0;
const path = require("path");
const util_1 = require("../util");
function tryProcessMacro(cwd, macro) {
    var _a, _b;
    if (!macro.startsWith("$")) {
        return undefined;
    }
    const basedir = path.basename(cwd);
    switch (macro) {
        case "$BASEDIR":
            return basedir;
        case "$GIT_REMOTE":
            const origin = util_1.execOrUndefined("git remote get-url origin", { cwd });
            if (origin) {
                return origin;
            }
            const slug = (_a = getFromGitConfig(cwd, "github.user")) !== null && _a !== void 0 ? _a : resolveEmail(cwd).split("@")[0];
            return `https://github.com/${slug}/${basedir}.git`;
        case "$GIT_USER_NAME":
            return (_b = getFromGitConfig(cwd, "user.name")) !== null && _b !== void 0 ? _b : "user";
        case "$GIT_USER_EMAIL":
            return resolveEmail(cwd);
        case "$PYTHON_MODULE_NAME":
            return util_1.formatAsPythonModule(basedir);
    }
    return undefined;
}
exports.tryProcessMacro = tryProcessMacro;
/**
 * Returns a value from git config. Searches local and then global git config.
 * @param key the config key
 */
function getFromGitConfig(cwd, key) {
    var _a;
    return ((_a = util_1.execOrUndefined(`git config --get --includes ${key}`, { cwd })) !== null && _a !== void 0 ? _a : util_1.execOrUndefined(`git config --get --global --includes ${key}`, { cwd }));
}
function resolveEmail(cwd) {
    var _a;
    return (_a = getFromGitConfig(cwd, "user.email")) !== null && _a !== void 0 ? _a : "user@domain.com";
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFjcm9zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NsaS9tYWNyb3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkJBQTZCO0FBQzdCLGtDQUFnRTtBQUVoRSxTQUFnQixlQUFlLENBQUMsR0FBVyxFQUFFLEtBQWE7O0lBQ3hELElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1FBQzFCLE9BQU8sU0FBUyxDQUFDO0tBQ2xCO0lBRUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUVuQyxRQUFRLEtBQUssRUFBRTtRQUNiLEtBQUssVUFBVTtZQUNiLE9BQU8sT0FBTyxDQUFDO1FBQ2pCLEtBQUssYUFBYTtZQUNoQixNQUFNLE1BQU0sR0FBRyxzQkFBZSxDQUFDLDJCQUEyQixFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztZQUNyRSxJQUFJLE1BQU0sRUFBRTtnQkFDVixPQUFPLE1BQU0sQ0FBQzthQUNmO1lBQ0QsTUFBTSxJQUFJLFNBQ1IsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGFBQWEsQ0FBQyxtQ0FBSSxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQzFFLE9BQU8sc0JBQXNCLElBQUksSUFBSSxPQUFPLE1BQU0sQ0FBQztRQUVyRCxLQUFLLGdCQUFnQjtZQUNuQixhQUFPLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxXQUFXLENBQUMsbUNBQUksTUFBTSxDQUFDO1FBQ3RELEtBQUssaUJBQWlCO1lBQ3BCLE9BQU8sWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzNCLEtBQUsscUJBQXFCO1lBQ3hCLE9BQU8sMkJBQW9CLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDeEM7SUFFRCxPQUFPLFNBQVMsQ0FBQztBQUNuQixDQUFDO0FBNUJELDBDQTRCQztBQUVEOzs7R0FHRztBQUNILFNBQVMsZ0JBQWdCLENBQUMsR0FBVyxFQUFFLEdBQVc7O0lBQ2hELE9BQU8sT0FDTCxzQkFBZSxDQUFDLCtCQUErQixHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLG1DQUM5RCxzQkFBZSxDQUFDLHdDQUF3QyxHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQ3hFLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBUyxZQUFZLENBQUMsR0FBVzs7SUFDL0IsYUFBTyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsWUFBWSxDQUFDLG1DQUFJLGlCQUFpQixDQUFDO0FBQ2xFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gXCJwYXRoXCI7XG5pbXBvcnQgeyBleGVjT3JVbmRlZmluZWQsIGZvcm1hdEFzUHl0aG9uTW9kdWxlIH0gZnJvbSBcIi4uL3V0aWxcIjtcblxuZXhwb3J0IGZ1bmN0aW9uIHRyeVByb2Nlc3NNYWNybyhjd2Q6IHN0cmluZywgbWFjcm86IHN0cmluZykge1xuICBpZiAoIW1hY3JvLnN0YXJ0c1dpdGgoXCIkXCIpKSB7XG4gICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgfVxuXG4gIGNvbnN0IGJhc2VkaXIgPSBwYXRoLmJhc2VuYW1lKGN3ZCk7XG5cbiAgc3dpdGNoIChtYWNybykge1xuICAgIGNhc2UgXCIkQkFTRURJUlwiOlxuICAgICAgcmV0dXJuIGJhc2VkaXI7XG4gICAgY2FzZSBcIiRHSVRfUkVNT1RFXCI6XG4gICAgICBjb25zdCBvcmlnaW4gPSBleGVjT3JVbmRlZmluZWQoXCJnaXQgcmVtb3RlIGdldC11cmwgb3JpZ2luXCIsIHsgY3dkIH0pO1xuICAgICAgaWYgKG9yaWdpbikge1xuICAgICAgICByZXR1cm4gb3JpZ2luO1xuICAgICAgfVxuICAgICAgY29uc3Qgc2x1ZyA9XG4gICAgICAgIGdldEZyb21HaXRDb25maWcoY3dkLCBcImdpdGh1Yi51c2VyXCIpID8/IHJlc29sdmVFbWFpbChjd2QpLnNwbGl0KFwiQFwiKVswXTtcbiAgICAgIHJldHVybiBgaHR0cHM6Ly9naXRodWIuY29tLyR7c2x1Z30vJHtiYXNlZGlyfS5naXRgO1xuXG4gICAgY2FzZSBcIiRHSVRfVVNFUl9OQU1FXCI6XG4gICAgICByZXR1cm4gZ2V0RnJvbUdpdENvbmZpZyhjd2QsIFwidXNlci5uYW1lXCIpID8/IFwidXNlclwiO1xuICAgIGNhc2UgXCIkR0lUX1VTRVJfRU1BSUxcIjpcbiAgICAgIHJldHVybiByZXNvbHZlRW1haWwoY3dkKTtcbiAgICBjYXNlIFwiJFBZVEhPTl9NT0RVTEVfTkFNRVwiOlxuICAgICAgcmV0dXJuIGZvcm1hdEFzUHl0aG9uTW9kdWxlKGJhc2VkaXIpO1xuICB9XG5cbiAgcmV0dXJuIHVuZGVmaW5lZDtcbn1cblxuLyoqXG4gKiBSZXR1cm5zIGEgdmFsdWUgZnJvbSBnaXQgY29uZmlnLiBTZWFyY2hlcyBsb2NhbCBhbmQgdGhlbiBnbG9iYWwgZ2l0IGNvbmZpZy5cbiAqIEBwYXJhbSBrZXkgdGhlIGNvbmZpZyBrZXlcbiAqL1xuZnVuY3Rpb24gZ2V0RnJvbUdpdENvbmZpZyhjd2Q6IHN0cmluZywga2V5OiBzdHJpbmcpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICByZXR1cm4gKFxuICAgIGV4ZWNPclVuZGVmaW5lZChgZ2l0IGNvbmZpZyAtLWdldCAtLWluY2x1ZGVzICR7a2V5fWAsIHsgY3dkIH0pID8/XG4gICAgZXhlY09yVW5kZWZpbmVkKGBnaXQgY29uZmlnIC0tZ2V0IC0tZ2xvYmFsIC0taW5jbHVkZXMgJHtrZXl9YCwgeyBjd2QgfSlcbiAgKTtcbn1cblxuZnVuY3Rpb24gcmVzb2x2ZUVtYWlsKGN3ZDogc3RyaW5nKTogc3RyaW5nIHtcbiAgcmV0dXJuIGdldEZyb21HaXRDb25maWcoY3dkLCBcInVzZXIuZW1haWxcIikgPz8gXCJ1c2VyQGRvbWFpbi5jb21cIjtcbn1cbiJdfQ==