"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_model_1 = require("./workflows-model");
/**
 * Auto approve pull requests that meet a criteria
 */
class AutoApprove extends component_1.Component {
    constructor(github, options = {}) {
        var _b, _c, _d, _e;
        super(github.project);
        this.label = (_b = options.label) !== null && _b !== void 0 ? _b : "auto-approve";
        const usernames = (_c = options.allowedUsernames) !== null && _c !== void 0 ? _c : ["github-actions[bot]"];
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += " && (";
            condition += usernames
                .map((u) => `github.event.pull_request.user.login == '${u}'`)
                .join(" || ");
            condition += ")";
        }
        const secret = (_d = options.secret) !== null && _d !== void 0 ? _d : "GITHUB_TOKEN";
        const approveJob = {
            runsOn: (_e = options.runsOn) !== null && _e !== void 0 ? _e : ["ubuntu-latest"],
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [
                {
                    uses: "hmarr/auto-approve-action@v2.1.0",
                    with: {
                        "github-token": `\${{ secrets.${secret} }}`,
                    },
                },
            ],
        };
        const workflow = github.addWorkflow("auto-approve");
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: [
                    "labeled",
                    "opened",
                    "synchronize",
                    "reopened",
                    "ready_for_review",
                ],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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