"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoMerge = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Sets up mergify to merging approved pull requests.
 *
 * If `buildJob` is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 *
 * `approvedReviews` specified the number of code review approvals required for
 * the PR to be merged.
 */
class AutoMerge extends component_1.Component {
    constructor(github, options = {}) {
        var _b, _c;
        super(github.project);
        this.lazyConditions = new Array();
        const mergify = github.mergify;
        if (!mergify) {
            throw new Error("auto merging requires mergify to be enabled");
        }
        const blockingLabels = (_b = options.blockingLabels) !== null && _b !== void 0 ? _b : ["do-not-merge"];
        const blockingCondition = (blockingLabels === null || blockingLabels === void 0 ? void 0 : blockingLabels.length) ? [`-label~=(${blockingLabels.join("|")})`]
            : [];
        const mergeAction = {
            delete_head_branch: {},
            queue: {
                // squash all commits into a single commit when merging
                // method: "squash",
                method: "squash",
                name: "default",
                // use PR title+body as the commit message
                commit_message_template: [
                    "{{ title }} (#{{ number }})",
                    "",
                    "{{ body }}",
                ].join("\n"),
            },
        };
        const approvedReviews = (_c = options.approvedReviews) !== null && _c !== void 0 ? _c : 1;
        // add initial conditions (additional conditions can be added later)
        this.addConditions(`#approved-reviews-by>=${approvedReviews}`);
        this.addConditions(...blockingCondition);
        mergify.addRule({
            name: "Automatic merge on approval and successful build",
            actions: mergeAction,
            conditions: (() => this.renderConditions()),
        });
        mergify.addQueue({
            name: "default",
            conditions: (() => this.renderConditions()),
        });
        this.project.addPackageIgnore("/.mergify.yml");
    }
    /**
     * Adds conditions to the auto merge rule.
     * @param conditions The conditions to add (mergify syntax)
     */
    addConditions(...conditions) {
        this.addConditionsLater({ render: () => conditions });
    }
    /**
     * Adds conditions that will be rendered only during synthesis.
     * @param later The later
     */
    addConditionsLater(later) {
        this.lazyConditions.push(later);
    }
    renderConditions() {
        const output = new Array();
        for (const later of this.lazyConditions) {
            output.push(...later.render());
        }
        return output;
    }
}
exports.AutoMerge = AutoMerge;
_a = JSII_RTTI_SYMBOL_1;
AutoMerge[_a] = { fqn: "projen.github.AutoMerge", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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