"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = exports.DependabotRegistryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
/**
 * Each configuration type requires you to provide particular settings.
 * Some types allow more than one way to connect
 * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries
 */
var DependabotRegistryType;
(function (DependabotRegistryType) {
    /**
     * The composer-repository type supports username and password.
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#composer-repository
     */
    DependabotRegistryType["COMPOSER_REGISTRY"] = "composer-registry";
    /**
     * The docker-registry type supports username and password.
     * The docker-registry type can also be used to pull from Amazon ECR using static AWS credentials
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#docker-registry
     */
    DependabotRegistryType["DOCKER_REGISTRY"] = "docker-registry";
    /**
     * The git type supports username and password
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#git
     */
    DependabotRegistryType["GIT"] = "git";
    /**
     * The hex-organization type supports organization and key
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#hex-organization
     */
    DependabotRegistryType["HEX_ORGANIZATION"] = "hex-organization";
    /**
     * The maven-repository type supports username and password, or token
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#maven-repository
     */
    DependabotRegistryType["MAVEN_REPOSITORY"] = "maven-repository";
    /**
     * The npm-registry type supports username and password, or token
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#npm-registry
     */
    DependabotRegistryType["NPM_REGISTRY"] = "npm-registry";
    /**
     * The nuget-feed type supports username and password, or token
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#nuget-feed
     */
    DependabotRegistryType["NUGET_FEED"] = "nuget-feed";
    /**
     * The python-index type supports username and password, or token
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#python-index
     */
    DependabotRegistryType["PYTHON_INDEX"] = "python-index";
    /**
     * The rubygems-server type supports username and password, or token
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#rubygems-server
     */
    DependabotRegistryType["RUBYGEMS_SERVER"] = "rubygems-server";
    /**
     * The terraform-registry type supports a token
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#terraform-registry
     */
    DependabotRegistryType["TERRAFORM_REGISTRY"] = "terraform-registry";
})(DependabotRegistryType = exports.DependabotRegistryType || (exports.DependabotRegistryType = {}));
/**
 * How often to check for new versions and raise pull requests for version
 * updates.
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    /**
     * Runs on every weekday, Monday to Friday.
     */
    DependabotScheduleInterval["DAILY"] = "daily";
    /**
     * Runs once each week. By default, this is on Monday.
     */
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    /**
     * Runs once each month. This is on the first day of the month.
     */
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * The strategy to use when edits manifest and lock files.
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    /**
     * Only create pull requests to update lockfiles updates. Ignore any new
     * versions that would require package manifest changes.
     */
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    /**
     * - For apps, the version requirements are increased.
     * - For libraries, the range of versions is widened.
     */
    VersioningStrategy["AUTO"] = "auto";
    /**
     * Relax the version requirement to include both the new and old version, when
     * possible.
     */
    VersioningStrategy["WIDEN"] = "widen";
    /**
     * Always increase the version requirement to match the new version.
     */
    VersioningStrategy["INCREASE"] = "increase";
    /**
     * Increase the version requirement only when required by the new version.
     */
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 */
class Dependabot extends component_1.Component {
    constructor(github, options = {}) {
        var _b, _c, _d, _e;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        this.ignoresProjen = (_b = options.ignoreProjen) !== null && _b !== void 0 ? _b : true;
        const registries = options.registries
            ? util_1.kebabCaseKeys(options.registries)
            : undefined;
        this.config = {
            version: 2,
            registries,
            updates: [
                {
                    "package-ecosystem": "npm",
                    "versioning-strategy": "lockfile-only",
                    directory: "/",
                    schedule: {
                        interval: (_c = options.scheduleInterval) !== null && _c !== void 0 ? _c : DependabotScheduleInterval.DAILY,
                    },
                    ignore: () => (this.ignore.length > 0 ? this.ignore : undefined),
                    labels: options.labels ? options.labels : undefined,
                    registries: registries ? Object.keys(registries) : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, ".github/dependabot.yml", {
            obj: this.config,
            committed: true,
        });
        for (const i of (_d = options.ignore) !== null && _d !== void 0 ? _d : []) {
            this.addIgnore(i.dependencyName, ...((_e = i.versions) !== null && _e !== void 0 ? _e : []));
        }
        if (this.ignoresProjen) {
            this.addIgnore("projen");
        }
    }
    /**
     * Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching
     * names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions. If
     * you want to define a range, use the standard pattern for the package
     * manager (for example: `^1.0.0` for npm, or `~> 2.0` for Bundler).
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            "dependency-name": dependencyName,
            versions: () => (versions.length > 0 ? versions : undefined),
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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