"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const clobber_1 = require("../clobber");
const gitpod_1 = require("../gitpod");
const project_1 = require("../project");
const readme_1 = require("../readme");
const vscode_1 = require("../vscode");
/**
 * GitHub-based project.
 *
 * @deprecated This is a *temporary* class. At the moment, our base project
 * types such as `NodeProject` and `JavaProject` are derived from this, but we
 * want to be able to use these project types outside of GitHub as well. One of
 * the next steps to address this is to abstract workflows so that different
 * "engines" can be used to implement our CI/CD solutions.
 */
class GitHubProject extends project_1.Project {
    constructor(options) {
        var _b, _c, _d, _e, _f;
        super(options);
        this.projectType = (_b = options.projectType) !== null && _b !== void 0 ? _b : project_1.ProjectType.UNKNOWN;
        // we only allow these global services to be used in root projects
        const github = (_c = options.github) !== null && _c !== void 0 ? _c : (this.parent ? false : true);
        this.github = github
            ? new _1.GitHub(this, {
                projenTokenSecret: options.projenTokenSecret,
                mergify: options.mergify,
                mergifyOptions: options.mergifyOptions,
                ...options.githubOptions,
            })
            : undefined;
        const vscode = (_d = options.vscode) !== null && _d !== void 0 ? _d : (this.parent ? false : true);
        this.vscode = vscode ? new vscode_1.VsCode(this) : undefined;
        this.gitpod = options.gitpod ? new gitpod_1.Gitpod(this) : undefined;
        this.devContainer = options.devContainer
            ? new vscode_1.DevContainer(this)
            : undefined;
        if ((_e = options.clobber) !== null && _e !== void 0 ? _e : true) {
            new clobber_1.Clobber(this);
        }
        new readme_1.SampleReadme(this, options.readme);
        if (options.autoApproveOptions && this.github) {
            this.autoApprove = new _1.AutoApprove(this.github, options.autoApproveOptions);
        }
        const stale = (_f = options.stale) !== null && _f !== void 0 ? _f : true;
        if (stale && this.github) {
            new _1.Stale(this.github, options.staleOptions);
        }
    }
    /**
     * Marks the provided file(s) as being generated. This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     *
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     */
    annotateGenerated(glob) {
        this.gitattributes.addAttributes(glob, "linguist-generated");
    }
}
exports.GitHubProject = GitHubProject;
_a = JSII_RTTI_SYMBOL_1;
GitHubProject[_a] = { fqn: "projen.github.GitHubProject", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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