"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependabot_1 = require("./dependabot");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const pull_request_lint_1 = require("./pull-request-lint");
const workflows_1 = require("./workflows");
class GitHub extends component_1.Component {
    constructor(project, options = {}) {
        var _b, _c, _d, _e;
        super(project);
        this.workflowsEnabled = (_b = options.workflows) !== null && _b !== void 0 ? _b : true;
        this.projenTokenSecret = (_c = options.projenTokenSecret) !== null && _c !== void 0 ? _c : "PROJEN_GITHUB_TOKEN";
        if ((_d = options.mergify) !== null && _d !== void 0 ? _d : true) {
            this.mergify = new mergify_1.Mergify(this, options.mergifyOptions);
        }
        if ((_e = options.pullRequestLint) !== null && _e !== void 0 ? _e : true) {
            new pull_request_lint_1.PullRequestLint(this, options.pullRequestLintOptions);
        }
    }
    /**
     * Returns the `GitHub` component of a project or `undefined` if the project
     * does not have a GitHub component.
     */
    static of(project) {
        const isGitHub = (c) => c instanceof GitHub;
        return project.components.find(isGitHub);
    }
    /**
     * All workflows.
     */
    get workflows() {
        const isWorkflow = (c) => c instanceof workflows_1.GithubWorkflow;
        return this.project.components
            .filter(isWorkflow)
            .sort((w1, w2) => w1.name.localeCompare(w2.name));
    }
    /**
     * Adds a workflow to the project.
     * @param name Name of the workflow
     * @returns a GithubWorkflow instance
     */
    addWorkflow(name) {
        const workflow = new workflows_1.GithubWorkflow(this, name);
        return workflow;
    }
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * Finds a GitHub workflow by name. Returns `undefined` if the workflow cannot be found.
     * @param name The name of the GitHub workflow
     */
    tryFindWorkflow(name) {
        return this.workflows.find((w) => w.name === name);
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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