"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullRequestLint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_model_1 = require("./workflows-model");
/**
 * Configure validations to run on GitHub pull requests.
 * Only generates a file if at least one linter is configured.
 */
class PullRequestLint extends component_1.Component {
    constructor(github, options = {}) {
        var _b, _c, _d, _e, _f;
        super(github.project);
        // should only create a workflow if one or more linters are enabled
        if ((_b = options.semanticTitle) !== null && _b !== void 0 ? _b : true) {
            const opts = (_c = options.semanticTitleOptions) !== null && _c !== void 0 ? _c : {};
            const types = (_d = opts.types) !== null && _d !== void 0 ? _d : ["feat", "fix", "chore"];
            const validateJob = {
                name: "Validate PR title",
                runsOn: (_e = options.runsOn) !== null && _e !== void 0 ? _e : ["ubuntu-latest"],
                permissions: {
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: "amannn/action-semantic-pull-request@v3.4.6",
                        env: {
                            GITHUB_TOKEN: "${{ secrets.GITHUB_TOKEN }}",
                        },
                        with: {
                            types: types.join("\n"),
                            requireScope: (_f = opts.requireScope) !== null && _f !== void 0 ? _f : false,
                        },
                    },
                ],
            };
            const workflow = github.addWorkflow("pull-request-lint");
            workflow.on({
                pullRequestTarget: {
                    types: [
                        "labeled",
                        "opened",
                        "synchronize",
                        "reopened",
                        "ready_for_review",
                        "edited",
                    ],
                },
            });
            workflow.addJobs({ validate: validateJob });
        }
    }
}
exports.PullRequestLint = PullRequestLint;
_a = JSII_RTTI_SYMBOL_1;
PullRequestLint[_a] = { fqn: "projen.github.PullRequestLint", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHVsbC1yZXF1ZXN0LWxpbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ2l0aHViL3B1bGwtcmVxdWVzdC1saW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EsNENBQXlDO0FBQ3pDLHVEQUF1RDtBQThDdkQ7OztHQUdHO0FBQ0gsTUFBYSxlQUFnQixTQUFRLHFCQUFTO0lBQzVDLFlBQVksTUFBYyxFQUFFLFVBQWtDLEVBQUU7O1FBQzlELEtBQUssQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFdEIsbUVBQW1FO1FBQ25FLFVBQUksT0FBTyxDQUFDLGFBQWEsbUNBQUksSUFBSSxFQUFFO1lBQ2pDLE1BQU0sSUFBSSxTQUFHLE9BQU8sQ0FBQyxvQkFBb0IsbUNBQUksRUFBRSxDQUFDO1lBQ2hELE1BQU0sS0FBSyxTQUFHLElBQUksQ0FBQyxLQUFLLG1DQUFJLENBQUMsTUFBTSxFQUFFLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztZQUVyRCxNQUFNLFdBQVcsR0FBUTtnQkFDdkIsSUFBSSxFQUFFLG1CQUFtQjtnQkFDekIsTUFBTSxRQUFFLE9BQU8sQ0FBQyxNQUFNLG1DQUFJLENBQUMsZUFBZSxDQUFDO2dCQUMzQyxXQUFXLEVBQUU7b0JBQ1gsWUFBWSxFQUFFLCtCQUFhLENBQUMsS0FBSztpQkFDbEM7Z0JBQ0QsS0FBSyxFQUFFO29CQUNMO3dCQUNFLElBQUksRUFBRSw0Q0FBNEM7d0JBQ2xELEdBQUcsRUFBRTs0QkFDSCxZQUFZLEVBQUUsNkJBQTZCO3lCQUM1Qzt3QkFDRCxJQUFJLEVBQUU7NEJBQ0osS0FBSyxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDOzRCQUN2QixZQUFZLFFBQUUsSUFBSSxDQUFDLFlBQVksbUNBQUksS0FBSzt5QkFDekM7cUJBQ0Y7aUJBQ0Y7YUFDRixDQUFDO1lBRUYsTUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1lBQ3pELFFBQVEsQ0FBQyxFQUFFLENBQUM7Z0JBQ1YsaUJBQWlCLEVBQUU7b0JBQ2pCLEtBQUssRUFBRTt3QkFDTCxTQUFTO3dCQUNULFFBQVE7d0JBQ1IsYUFBYTt3QkFDYixVQUFVO3dCQUNWLGtCQUFrQjt3QkFDbEIsUUFBUTtxQkFDVDtpQkFDRjthQUNGLENBQUMsQ0FBQztZQUNILFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxRQUFRLEVBQUUsV0FBVyxFQUFFLENBQUMsQ0FBQztTQUM3QztJQUNILENBQUM7O0FBNUNILDBDQTZDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdpdEh1YiB9IGZyb20gXCIuXCI7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBKb2IsIEpvYlBlcm1pc3Npb24gfSBmcm9tIFwiLi93b3JrZmxvd3MtbW9kZWxcIjtcblxuLyoqXG4gKiBPcHRpb25zIGZvciBQdWxsUmVxdWVzdExpbnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBQdWxsUmVxdWVzdExpbnRPcHRpb25zIHtcbiAgLyoqXG4gICAqIFZhbGlkYXRlIHRoYXQgcHVsbCByZXF1ZXN0IHRpdGxlcyBmb2xsb3cgQ29udmVudGlvbmFsIENvbW1pdHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICogQHNlZSBodHRwczovL3d3dy5jb252ZW50aW9uYWxjb21taXRzLm9yZy9cbiAgICovXG4gIHJlYWRvbmx5IHNlbWFudGljVGl0bGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBPcHRpb25zIGZvciB2YWxpZGF0aW5nIHRoZSBjb252ZW50aW9uYWwgY29tbWl0IHRpdGxlIGxpbnRlci5cbiAgICogQGRlZmF1bHQgLSB0aXRsZSBtdXN0IHN0YXJ0IHdpdGggXCJmZWF0XCIsIFwiZml4XCIsIG9yIFwiY2hvcmVcIlxuICAgKi9cbiAgcmVhZG9ubHkgc2VtYW50aWNUaXRsZU9wdGlvbnM/OiBTZW1hbnRpY1RpdGxlT3B0aW9ucztcblxuICAvKipcbiAgICogR2l0aHViIFJ1bm5lciBzZWxlY3Rpb24gbGFiZWxzXG4gICAqIEBkZWZhdWx0IFtcInVidW50dS1sYXRlc3RcIl1cbiAgICovXG4gIHJlYWRvbmx5IHJ1bnNPbj86IHN0cmluZ1tdO1xufVxuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGxpbnRpbmcgdGhhdCBQUiB0aXRsZXMgZm9sbG93IENvbnZlbnRpb25hbCBDb21taXRzLlxuICogQHNlZSBodHRwczovL3d3dy5jb252ZW50aW9uYWxjb21taXRzLm9yZy9cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZW1hbnRpY1RpdGxlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBDb25maWd1cmUgYSBsaXN0IG9mIGNvbW1pdCB0eXBlcyB0aGF0IGFyZSBhbGxvd2VkLlxuICAgKiBAZGVmYXVsdCBbXCJmZWF0XCIsIFwiZml4XCIsIFwiY2hvcmVcIl1cbiAgICovXG4gIHJlYWRvbmx5IHR5cGVzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyZSB0aGF0IGEgc2NvcGUgbXVzdCBhbHdheXMgYmUgcHJvdmlkZWQuXG4gICAqIGUuZy4gZmVhdCh1aSksIGZpeChjb3JlKVxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVxdWlyZVNjb3BlPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBDb25maWd1cmUgdmFsaWRhdGlvbnMgdG8gcnVuIG9uIEdpdEh1YiBwdWxsIHJlcXVlc3RzLlxuICogT25seSBnZW5lcmF0ZXMgYSBmaWxlIGlmIGF0IGxlYXN0IG9uZSBsaW50ZXIgaXMgY29uZmlndXJlZC5cbiAqL1xuZXhwb3J0IGNsYXNzIFB1bGxSZXF1ZXN0TGludCBleHRlbmRzIENvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKGdpdGh1YjogR2l0SHViLCBvcHRpb25zOiBQdWxsUmVxdWVzdExpbnRPcHRpb25zID0ge30pIHtcbiAgICBzdXBlcihnaXRodWIucHJvamVjdCk7XG5cbiAgICAvLyBzaG91bGQgb25seSBjcmVhdGUgYSB3b3JrZmxvdyBpZiBvbmUgb3IgbW9yZSBsaW50ZXJzIGFyZSBlbmFibGVkXG4gICAgaWYgKG9wdGlvbnMuc2VtYW50aWNUaXRsZSA/PyB0cnVlKSB7XG4gICAgICBjb25zdCBvcHRzID0gb3B0aW9ucy5zZW1hbnRpY1RpdGxlT3B0aW9ucyA/PyB7fTtcbiAgICAgIGNvbnN0IHR5cGVzID0gb3B0cy50eXBlcyA/PyBbXCJmZWF0XCIsIFwiZml4XCIsIFwiY2hvcmVcIl07XG5cbiAgICAgIGNvbnN0IHZhbGlkYXRlSm9iOiBKb2IgPSB7XG4gICAgICAgIG5hbWU6IFwiVmFsaWRhdGUgUFIgdGl0bGVcIixcbiAgICAgICAgcnVuc09uOiBvcHRpb25zLnJ1bnNPbiA/PyBbXCJ1YnVudHUtbGF0ZXN0XCJdLFxuICAgICAgICBwZXJtaXNzaW9uczoge1xuICAgICAgICAgIHB1bGxSZXF1ZXN0czogSm9iUGVybWlzc2lvbi5XUklURSxcbiAgICAgICAgfSxcbiAgICAgICAgc3RlcHM6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICB1c2VzOiBcImFtYW5ubi9hY3Rpb24tc2VtYW50aWMtcHVsbC1yZXF1ZXN0QHYzLjQuNlwiLFxuICAgICAgICAgICAgZW52OiB7XG4gICAgICAgICAgICAgIEdJVEhVQl9UT0tFTjogXCIke3sgc2VjcmV0cy5HSVRIVUJfVE9LRU4gfX1cIixcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB3aXRoOiB7XG4gICAgICAgICAgICAgIHR5cGVzOiB0eXBlcy5qb2luKFwiXFxuXCIpLFxuICAgICAgICAgICAgICByZXF1aXJlU2NvcGU6IG9wdHMucmVxdWlyZVNjb3BlID8/IGZhbHNlLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgfTtcblxuICAgICAgY29uc3Qgd29ya2Zsb3cgPSBnaXRodWIuYWRkV29ya2Zsb3coXCJwdWxsLXJlcXVlc3QtbGludFwiKTtcbiAgICAgIHdvcmtmbG93Lm9uKHtcbiAgICAgICAgcHVsbFJlcXVlc3RUYXJnZXQ6IHtcbiAgICAgICAgICB0eXBlczogW1xuICAgICAgICAgICAgXCJsYWJlbGVkXCIsXG4gICAgICAgICAgICBcIm9wZW5lZFwiLFxuICAgICAgICAgICAgXCJzeW5jaHJvbml6ZVwiLFxuICAgICAgICAgICAgXCJyZW9wZW5lZFwiLFxuICAgICAgICAgICAgXCJyZWFkeV9mb3JfcmV2aWV3XCIsXG4gICAgICAgICAgICBcImVkaXRlZFwiLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICAgIHdvcmtmbG93LmFkZEpvYnMoeyB2YWxpZGF0ZTogdmFsaWRhdGVKb2IgfSk7XG4gICAgfVxuICB9XG59XG4iXX0=