"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBehavior = void 0;
function renderBehavior(behavior, opts) {
    var _a, _b, _c, _d, _e, _f, _g;
    const enabled = (_a = behavior === null || behavior === void 0 ? void 0 : behavior.enabled) !== null && _a !== void 0 ? _a : true;
    if (!enabled) {
        return { daysBeforeStale: -1, daysBeforeClose: -1 };
    }
    const exemptLabels = (_b = behavior === null || behavior === void 0 ? void 0 : behavior.exemptLabels) !== null && _b !== void 0 ? _b : ["backlog"];
    const messageSuffix = exemptLabels.length > 0
        ? ` If you wish to exclude this issue from being marked as stale, add the "${exemptLabels[0]}" label.`
        : "";
    return {
        daysBeforeStale: (_c = behavior === null || behavior === void 0 ? void 0 : behavior.daysBeforeStale) !== null && _c !== void 0 ? _c : opts.stale,
        daysBeforeClose: (_d = behavior === null || behavior === void 0 ? void 0 : behavior.daysBeforeClose) !== null && _d !== void 0 ? _d : opts.close,
        staleMessage: (_e = behavior === null || behavior === void 0 ? void 0 : behavior.staleMessage) !== null && _e !== void 0 ? _e : `This ${opts.type} is now marked as stale because it hasn\'t seen activity for a while. Add a comment or it will be closed soon.${messageSuffix}`,
        closeMessage: (_f = behavior === null || behavior === void 0 ? void 0 : behavior.closeMessage) !== null && _f !== void 0 ? _f : `Closing this ${opts.type} as it hasn\'t seen activity for a while. Please add a comment @mentioning a maintainer to reopen.${messageSuffix}`,
        staleLabel: (_g = behavior === null || behavior === void 0 ? void 0 : behavior.staleLabel) !== null && _g !== void 0 ? _g : "stale",
        exemptLabels: exemptLabels,
    };
}
exports.renderBehavior = renderBehavior;
//# sourceMappingURL=data:application/json;base64,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