"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stale = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const stale_util_1 = require("./stale-util");
const workflows_model_1 = require("./workflows-model");
/**
 * Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 *
 * The default configuration will:
 *
 *  * Add a "Stale" label to pull requests after 14 days and closed after 2 days
 *  * Add a "Stale" label to issues after 60 days and closed after 7 days
 *  * If a comment is added, the label will be removed and timer is restarted.
 *
 * @see https://github.com/actions/stale
 */
class Stale extends component_1.Component {
    constructor(github, options = {}) {
        var _b;
        super(github.project);
        const stale = github.addWorkflow("stale");
        stale.on({
            schedule: [{ cron: "0 1 * * *" }],
            workflowDispatch: {},
        });
        const pullRequests = stale_util_1.renderBehavior(options.pullRequest, {
            stale: 14,
            close: 2,
            type: "pull request",
        });
        const issues = stale_util_1.renderBehavior(options.issues, {
            stale: 60,
            close: 7,
            type: "issue",
        });
        const renderExemptLabels = (exemptLabels) => {
            if (!exemptLabels || exemptLabels.length === 0) {
                return undefined;
            }
            return exemptLabels.join(",");
        };
        stale.addJobs({
            stale: {
                runsOn: (_b = options.runsOn) !== null && _b !== void 0 ? _b : ["ubuntu-latest"],
                permissions: {
                    issues: workflows_model_1.JobPermission.WRITE,
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: "actions/stale@v4",
                        with: {
                            // disable global
                            "days-before-stale": -1,
                            "days-before-close": -1,
                            // pull requests
                            "days-before-pr-stale": pullRequests.daysBeforeStale,
                            "days-before-pr-close": pullRequests.daysBeforeClose,
                            "stale-pr-message": pullRequests.staleMessage,
                            "close-pr-message": pullRequests.closeMessage,
                            "stale-pr-label": pullRequests.staleLabel,
                            "exempt-pr-labels": renderExemptLabels(pullRequests.exemptLabels),
                            // issues
                            "days-before-issue-stale": issues.daysBeforeStale,
                            "days-before-issue-close": issues.daysBeforeClose,
                            "stale-issue-message": issues.staleMessage,
                            "close-issue-message": issues.closeMessage,
                            "stale-issue-label": issues.staleLabel,
                            "exempt-issue-labels": renderExemptLabels(issues.exemptLabels),
                        },
                    },
                ],
            },
        });
    }
}
exports.Stale = Stale;
_a = JSII_RTTI_SYMBOL_1;
Stale[_a] = { fqn: "projen.github.Stale", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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