"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflow_actions_1 = require("./workflow-actions");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = "build";
/**
 * A GitHub workflow for common build tasks within a project.
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    constructor(github, options) {
        var _b, _c, _d, _e, _f, _g;
        super(github, options.name);
        this.jobId = (_b = options.jobId) !== null && _b !== void 0 ? _b : DEFAULT_JOB_ID;
        this.github = github;
        this.artifactsDirectory = options.artifactsDirectory;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {},
        });
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith
            ? { with: options.checkoutWith }
            : {};
        const preBuildSteps = (_d = options.preBuildSteps) !== null && _d !== void 0 ? _d : [];
        const postBuildSteps = (_e = options.postBuildSteps) !== null && _e !== void 0 ? _e : [];
        const gitIdentity = (_f = options.gitIdentity) !== null && _f !== void 0 ? _f : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (this.artifactsDirectory) {
            postBuildSteps.push({
                name: "Upload artifact",
                uses: "actions/upload-artifact@v2.1.1",
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: "always()",
                with: {
                    name: this.artifactsDirectory,
                    path: this.artifactsDirectory,
                },
            });
        }
        const job = {
            runsOn: (_g = options.runsOn) !== null && _g !== void 0 ? _g : ["ubuntu-latest"],
            container: options.container,
            env: options.env,
            permissions: options.permissions,
            if: options.condition,
            outputs: options.outputs,
            steps: [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: "Checkout",
                    uses: "actions/checkout@v2",
                    ...checkoutWith,
                },
                // sets git identity so we can push later
                ...workflow_actions_1.WorkflowActions.setGitIdentity(gitIdentity),
                ...preBuildSteps,
                // run the main build task
                {
                    name: options.task.name,
                    run: this.github.project.runTaskCommand(options.task),
                },
                ...postBuildSteps,
            ],
        };
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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