"use strict";
// @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobPermission = void 0;
/**
 * Access level for workflow permission scopes.
 */
var JobPermission;
(function (JobPermission) {
    /** Read-only access */
    JobPermission["READ"] = "read";
    /** Read-write access */
    JobPermission["WRITE"] = "write";
    /** No access at all */
    JobPermission["NONE"] = "none";
})(JobPermission = exports.JobPermission || (exports.JobPermission = {}));
//#endregion
//# sourceMappingURL=data:application/json;base64,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