"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const github_1 = require("../github");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
/**
 * Java project.
 *
 * @pjid java
 */
class JavaProject extends github_1.GitHubProject {
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(options);
        this.distdir = (_b = options.distdir) !== null && _b !== void 0 ? _b : "dist/java";
        this.pom = new pom_1.Pom(this, options);
        if ((_c = options.projenrcJava) !== null && _c !== void 0 ? _c : true) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, options.projenrcJavaOptions);
        }
        const sampleJavaPackage = (_d = options.sampleJavaPackage) !== null && _d !== void 0 ? _d : "org.acme";
        if ((_e = options.junit) !== null && _e !== void 0 ? _e : true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if ((_f = options.sample) !== null && _f !== void 0 ? _f : true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty("project.build.sourceEncoding", "UTF-8");
        this.gitignore.exclude(".classpath");
        this.gitignore.exclude(".project");
        this.gitignore.exclude(".settings");
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin("org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3", {
            executions: [{ id: "enforce-maven", goals: ["enforce"] }],
            configuration: {
                rules: [{ requireMavenVersion: [{ version: "3.6" }] }],
            },
        });
        for (const dep of (_g = options.deps) !== null && _g !== void 0 ? _g : []) {
            this.addDependency(dep);
        }
        for (const dep of (_h = options.testDeps) !== null && _h !== void 0 ? _h : []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`)
     * @param options plugin options
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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