"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenCompile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Adds the maven-compiler plugin to a POM file and the `compile` task.
 */
class MavenCompile extends component_1.Component {
    constructor(project, pom, options = {}) {
        var _b, _c;
        super(project);
        project.gitignore.exclude("target");
        pom.addPlugin("org.apache.maven.plugins/maven-compiler-plugin@3.8.1", {
            configuration: {
                source: (_b = options.source) !== null && _b !== void 0 ? _b : "1.8",
                target: (_c = options.target) !== null && _c !== void 0 ? _c : "1.8",
            },
        });
        project.compileTask.exec("mvn compiler:compile");
    }
}
exports.MavenCompile = MavenCompile;
_a = JSII_RTTI_SYMBOL_1;
MavenCompile[_a] = { fqn: "projen.java.MavenCompile", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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