"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenPackaging = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Configures a maven project to produce a .jar archive with sources and javadocs.
 */
class MavenPackaging extends component_1.Component {
    constructor(project, pom, options = {}) {
        var _b, _c, _d;
        super(project);
        pom.addPlugin("org.apache.maven.plugins/maven-jar-plugin@3.2.0", {
            configuration: {
                archive: {
                    index: true,
                    manifest: {
                        addDefaultImplementationEntries: true,
                        addDefaultSpecificationEntries: true,
                    },
                },
            },
        });
        if ((_b = options.sources) !== null && _b !== void 0 ? _b : true) {
            pom.addPlugin("org.apache.maven.plugins/maven-source-plugin@3.2.1", {
                executions: [{ id: "attach-sources", goals: ["jar"] }],
            });
        }
        if ((_c = options.javadocs) !== null && _c !== void 0 ? _c : true) {
            pom.addPlugin("org.apache.maven.plugins/maven-javadoc-plugin@3.2.0", {
                executions: [{ id: "attach-javadocs", goals: ["jar"] }],
                configuration: {
                    failOnError: false,
                    show: "protected",
                    sourceFileExcludes: { exclude: options.javadocsExclude },
                    detectJavaApiLink: false,
                    additionalJOptions: {
                        additionalJOption: [
                            "-J-XX:+TieredCompilation",
                            "-J-XX:TieredStopAtLevel=1",
                        ],
                    },
                },
            });
        }
        const env = {
            MAVEN_OPTS: "-XX:+TieredCompilation -XX:TieredStopAtLevel=1",
        };
        const distdir = (_d = options.distdir) !== null && _d !== void 0 ? _d : "dist/java";
        for (const [k, v] of Object.entries(env)) {
            this.project.packageTask.env(k, v);
        }
        this.project.packageTask.exec(`mkdir -p ${distdir}`);
        this.project.packageTask.exec(`mvn deploy -D=altDeploymentRepository=local::default::file:///$PWD/${distdir}`);
        project.gitignore.exclude(distdir);
    }
}
exports.MavenPackaging = MavenPackaging;
_a = JSII_RTTI_SYMBOL_1;
MavenPackaging[_a] = { fqn: "projen.java.MavenPackaging", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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