"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const json_1 = require("../json");
const DEFAULT_TEST_REPORTS_DIR = "test-reports";
/**
 * Installs the following npm scripts:
 *
 * - `test` will run `jest --passWithNoTests`
 * - `test:watch` will run `jest --watch`
 * - `test:update` will run `jest -u`
 *
 */
class Jest {
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2;
        this.project = project;
        // hard deprecation
        if (options.typescriptConfig) {
            throw new Error('"jestOptions.typescriptConfig" is deprecated. Use "typescriptProject.tsconfigDev" instead');
        }
        // Jest snapshot files are generated files!
        project.root.annotateGenerated("*.snap");
        const jestDep = options.jestVersion
            ? `jest@${options.jestVersion}`
            : "jest";
        project.addDevDeps(jestDep);
        this.jestConfig = options.jestConfig;
        this.ignorePatterns = (_d = (_c = (_b = this.jestConfig) === null || _b === void 0 ? void 0 : _b.testPathIgnorePatterns) !== null && _c !== void 0 ? _c : options.ignorePatterns) !== null && _d !== void 0 ? _d : ["/node_modules/"];
        this.watchIgnorePatterns = (_f = (_e = this.jestConfig) === null || _e === void 0 ? void 0 : _e.watchPathIgnorePatterns) !== null && _f !== void 0 ? _f : [
            "/node_modules/",
        ];
        this.coverageReporters = (_h = (_g = this.jestConfig) === null || _g === void 0 ? void 0 : _g.coverageReporters) !== null && _h !== void 0 ? _h : [
            "json",
            "lcov",
            "clover",
            "cobertura",
        ];
        this.testMatch = (_k = (_j = this.jestConfig) === null || _j === void 0 ? void 0 : _j.testMatch) !== null && _k !== void 0 ? _k : [
            "**/__tests__/**/*.[jt]s?(x)",
            "**/?(*.)+(spec|test).[tj]s?(x)",
        ];
        const coverageDirectory = (_m = (_l = this.jestConfig) === null || _l === void 0 ? void 0 : _l.coverageDirectory) !== null && _m !== void 0 ? _m : "coverage";
        this.reporters = [];
        if ((_o = options.preserveDefaultReporters) !== null && _o !== void 0 ? _o : true) {
            this.reporters.unshift("default");
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: (_q = (_p = this.jestConfig) === null || _p === void 0 ? void 0 : _p.clearMocks) !== null && _q !== void 0 ? _q : true,
            collectCoverage: (_t = (_r = options.coverage) !== null && _r !== void 0 ? _r : (_s = this.jestConfig) === null || _s === void 0 ? void 0 : _s.collectCoverage) !== null && _t !== void 0 ? _t : true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: (_v = (_u = this.jestConfig) === null || _u === void 0 ? void 0 : _u.coveragePathIgnorePatterns) !== null && _v !== void 0 ? _v : this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if ((_w = options.junitReporting) !== null && _w !== void 0 ? _w : true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter(["jest-junit", { outputDirectory: reportsDir }]);
            project.addDevDeps("jest-junit@^13");
            project.gitignore.exclude("# jest-junit artifacts", `/${reportsDir}/`, "junit.xml");
            (_x = project.npmignore) === null || _x === void 0 ? void 0 : _x.exclude("# jest-junit artifacts", `/${reportsDir}/`, "junit.xml");
        }
        if ((_y = this.jestConfig) === null || _y === void 0 ? void 0 : _y.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if ((_z = this.jestConfig) === null || _z === void 0 ? void 0 : _z.coverageThreshold) {
            this.config.coverageThreshold = {
                global: (_0 = this.jestConfig) === null || _0 === void 0 ? void 0 : _0.coverageThreshold,
            };
        }
        this.configureTestCommand();
        if (options.configFilePath) {
            this.file = new json_1.JsonFile(project, options.configFilePath, {
                obj: this.config,
            });
        }
        else {
            project.addFields({ jest: this.config });
        }
        const coverageDirectoryPath = path.posix.join("/", coverageDirectory, "/");
        (_1 = project.npmignore) === null || _1 === void 0 ? void 0 : _1.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if ((_2 = options.coverageText) !== null && _2 !== void 0 ? _2 : true) {
            this.coverageReporters.push("text");
        }
    }
    /**
     * Adds a test match pattern.
     * @param pattern glob pattern to match for tests
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * Adds a watch ignore pattern.
     * @param pattern The pattern (regular expression).
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    addSnapshotResolver(file) {
        this._snapshotResolver = file;
    }
    configureTestCommand() {
        const jestOpts = ["--passWithNoTests", "--all"];
        const jestConfigOpts = this.file && this.file.path != "jest.config.json"
            ? ` -c ${this.file.path}`
            : "";
        // since our build & release workflows have anti-tamper protection, it is
        // safe to always run tests with --updateSnapshot. if a snapshot changes,
        // the `build` workflow will either fail (on forks) or push the update and
        // `release` workflows will fail.
        jestOpts.push("--updateSnapshot");
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project.package.minNodeVersion &&
            semver.gte(this.project.package.minNodeVersion, "14.0.0")) {
            jestOpts.push("--coverageProvider=v8");
        }
        this.project.testTask.exec(`jest ${jestOpts.join(" ")}${jestConfigOpts}`);
        const testWatch = this.project.tasks.tryFind("test:watch");
        if (!testWatch) {
            this.project.addTask("test:watch", {
                description: "Run jest in watch mode",
                exec: `jest --watch${jestConfigOpts}`,
            });
        }
        const testUpdate = this.project.tasks.tryFind("test:update");
        if (!testUpdate) {
            this.project.addTask("test:update", {
                description: "Update jest snapshots",
                exec: `jest --updateSnapshot${jestConfigOpts}`,
            });
        }
    }
}
exports.Jest = Jest;
_a = JSII_RTTI_SYMBOL_1;
Jest[_a] = { fqn: "projen.javascript.Jest", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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