"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const build_1 = require("../build");
const common_1 = require("../common");
const github_1 = require("../github");
const constants_1 = require("../github/constants");
const ignore_file_1 = require("../ignore-file");
const javascript_1 = require("../javascript");
const license_1 = require("../license");
const release_1 = require("../release");
const util_1 = require("../util");
const version_1 = require("../version");
const bundler_1 = require("./bundler");
const jest_1 = require("./jest");
const node_package_1 = require("./node-package");
const projenrc_1 = require("./projenrc");
const upgrade_dependencies_1 = require("./upgrade-dependencies");
const PROJEN_SCRIPT = "projen";
/**
 * Automatic bump modes
 */
var AutoRelease;
(function (AutoRelease) {
    /**
     * Automatically bump & release a new version for every commit to "main"
     */
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    /**
     * Automatically bump & release a new version on a daily basis.
     */
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * Node.js project
 *
 * @pjid node
 */
class NodeProject extends github_1.GitHubProject {
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.workflowBootstrapSteps = (_b = options.workflowBootstrapSteps) !== null && _b !== void 0 ? _b : [];
        this.workflowGitIdentity = (_c = options.workflowGitIdentity) !== null && _c !== void 0 ? _c : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        this.artifactsDirectory = (_d = options.artifactsDirectory) !== null && _d !== void 0 ? _d : "dist";
        this.artifactsJavascriptDirectory = path_1.join(this.artifactsDirectory, "js");
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM:
                    return "npm run";
                case node_package_1.NodePackageManager.YARN:
                    return "yarn run";
                case node_package_1.NodePackageManager.PNPM:
                    return "pnpm run";
                default:
                    throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_e = options.workflowNodeVersion) !== null && _e !== void 0 ? _e : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment("PATH", '$(npx -c "node -e \\"console.log(process.env.PATH)\\"")');
        this.addLicense(options);
        if ((_f = options.npmignoreEnabled) !== null && _f !== void 0 ? _f : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, ".npmignore");
        }
        this.addDefaultGitIgnore();
        if ((_g = options.gitignore) === null || _g === void 0 ? void 0 : _g.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_h = options.npmignore) === null || _h === void 0 ? void 0 : _h.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        if (!this.ejected) {
            this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        }
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${common_1.PROJEN_RC}`);
        (_k = this.npmignore) === null || _k === void 0 ? void 0 : _k.exclude(`/${common_1.PROJEN_DIR}/`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_l = options.projenDevDependency) !== null && _l !== void 0 ? _l : true;
        if (projen && !this.ejected) {
            const postfix = options.projenVersion ? `@${options.projenVersion}` : "";
            this.addDevDeps(`projen${postfix}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_m = options.buildWorkflow) !== null && _m !== void 0 ? _m : (this.parent ? false : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_o = options.jest) !== null && _o !== void 0 ? _o : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if (buildEnabled && this.github) {
            this.buildWorkflow = new build_1.BuildWorkflow(this, {
                buildTask: this.buildTask,
                artifactsDirectory: this.artifactsDirectory,
                containerImage: options.workflowContainerImage,
                gitIdentity: this.workflowGitIdentity,
                mutableBuild: options.mutableBuild,
                preBuildSteps: this.renderWorkflowSetup({
                    mutable: (_p = options.mutableBuild) !== null && _p !== void 0 ? _p : true,
                }),
                postBuildSteps: options.postBuildSteps,
                runsOn: options.workflowRunsOn,
                workflowTriggers: options.buildWorkflowTriggers,
            });
            // run codecov if enabled or a secret token name is passed in
            // AND jest must be configured
            if ((options.codeCov || options.codeCovTokenSecret) && ((_q = this.jest) === null || _q === void 0 ? void 0 : _q.config)) {
                this.buildWorkflow.addPostBuildSteps({
                    name: "Upload coverage to Codecov",
                    uses: "codecov/codecov-action@v1",
                    with: options.codeCovTokenSecret
                        ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        }
                        : {
                            directory: this.jest.config.coverageDirectory,
                        },
                });
            }
        }
        const release = (_s = (_r = options.release) !== null && _r !== void 0 ? _r : options.releaseWorkflow) !== null && _s !== void 0 ? _s : (this.parent ? false : true);
        if (release) {
            this.addDevDeps(version_1.Version.STANDARD_VERSION);
            this.release = new release_1.Release(this, {
                versionFile: "package.json",
                task: this.buildTask,
                branch: (_t = options.defaultReleaseBranch) !== null && _t !== void 0 ? _t : "main",
                artifactsDirectory: this.artifactsDirectory,
                ...options,
                releaseWorkflowSetupSteps: [
                    ...this.renderWorkflowSetup({ mutable: false }),
                    ...((_u = options.releaseWorkflowSetupSteps) !== null && _u !== void 0 ? _u : []),
                ],
            });
            this.publisher = this.release.publisher;
            if ((_v = options.releaseToNpm) !== null && _v !== void 0 ? _v : false) {
                this.release.publisher.publishToNpm({
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                    codeArtifactOptions: {
                        accessKeyIdSecret: (_w = options.codeArtifactOptions) === null || _w === void 0 ? void 0 : _w.accessKeyIdSecret,
                        secretAccessKeySecret: (_x = options.codeArtifactOptions) === null || _x === void 0 ? void 0 : _x.secretAccessKeySecret,
                        roleToAssume: (_y = options.codeArtifactOptions) === null || _y === void 0 ? void 0 : _y.roleToAssume,
                    },
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if (((_z = this.github) === null || _z === void 0 ? void 0 : _z.mergify) && ((_0 = this.buildWorkflow) === null || _0 === void 0 ? void 0 : _0.buildJobIds)) {
            this.autoMerge = new github_1.AutoMerge(this.github, options.autoMergeOptions);
            this.autoMerge.addConditionsLater({
                render: () => { var _b, _c; return (_c = (_b = this.buildWorkflow) === null || _b === void 0 ? void 0 : _b.buildJobIds.map((id) => `status-success=${id}`)) !== null && _c !== void 0 ? _c : []; },
            });
        }
        const dependabot = (_1 = options.dependabot) !== null && _1 !== void 0 ? _1 : false;
        const depsUpgrade = (_2 = options.depsUpgrade) !== null && _2 !== void 0 ? _2 : !dependabot;
        if (dependabot && depsUpgrade) {
            throw new Error("'dependabot' cannot be configured together with 'depsUpgrade'");
        }
        if (options.projenUpgradeAutoMerge !== undefined &&
            options.autoApproveProjenUpgrades !== undefined) {
            throw new Error("'projenUpgradeAutoMerge' cannot be configured together with 'autoApproveProjenUpgrades'");
        }
        const projenAutoApprove = (_4 = (_3 = options.autoApproveProjenUpgrades) !== null && _3 !== void 0 ? _3 : options.projenUpgradeAutoMerge) !== null && _4 !== void 0 ? _4 : false;
        const depsAutoApprove = (_5 = options.autoApproveUpgrades) !== null && _5 !== void 0 ? _5 : false;
        if (projenAutoApprove && !this.autoApprove && this.github) {
            throw new Error("Automatic approval of projen upgrades requires configuring `autoApproveOptions`");
        }
        if (depsAutoApprove && !this.autoApprove && this.github) {
            throw new Error("Automatic approval of dependencies upgrades requires configuring `autoApproveOptions`");
        }
        const autoApproveLabel = (condition) => {
            var _b;
            return condition && ((_b = this.autoApprove) === null || _b === void 0 ? void 0 : _b.label)
                ? [this.autoApprove.label]
                : undefined;
        };
        let ignoresProjen;
        if (dependabot) {
            const defaultOptions = {
                labels: autoApproveLabel(depsAutoApprove),
            };
            const dependabotConf = (_6 = this.github) === null || _6 === void 0 ? void 0 : _6.addDependabot(util_1.deepMerge([defaultOptions, (_7 = options.dependabotOptions) !== null && _7 !== void 0 ? _7 : {}]));
            ignoresProjen = dependabotConf === null || dependabotConf === void 0 ? void 0 : dependabotConf.ignoresProjen;
        }
        if (depsUpgrade) {
            const defaultOptions = {
                // if projen secret is defined we can also upgrade projen here.
                ignoreProjen: !options.projenUpgradeSecret,
                workflowOptions: {
                    // if projen secret is defined, use it (otherwise default to GITHUB_TOKEN).
                    secret: options.projenUpgradeSecret,
                    container: options.workflowContainerImage
                        ? {
                            image: options.workflowContainerImage,
                        }
                        : undefined,
                    labels: autoApproveLabel(depsAutoApprove),
                    gitIdentity: this.workflowGitIdentity,
                },
            };
            const upgradeDependencies = new javascript_1.UpgradeDependencies(this, util_1.deepMerge([defaultOptions, (_8 = options.depsUpgradeOptions) !== null && _8 !== void 0 ? _8 : {}]));
            ignoresProjen = upgradeDependencies.ignoresProjen;
            this.upgradeWorkflow = upgradeDependencies;
        }
        // create a dedicated workflow to upgrade projen itself if needed
        if (ignoresProjen && this.package.packageName !== "projen") {
            new javascript_1.UpgradeDependencies(this, {
                include: ["projen"],
                taskName: "upgrade-projen",
                pullRequestTitle: "upgrade projen",
                ignoreProjen: false,
                workflow: !!options.projenUpgradeSecret,
                workflowOptions: {
                    schedule: upgrade_dependencies_1.UpgradeDependenciesSchedule.expressions((_9 = options.projenUpgradeSchedule) !== null && _9 !== void 0 ? _9 : ["0 6 * * *"]),
                    container: options.workflowContainerImage
                        ? { image: options.workflowContainerImage }
                        : undefined,
                    secret: options.projenUpgradeSecret,
                    labels: autoApproveLabel(projenAutoApprove),
                    gitIdentity: this.workflowGitIdentity,
                },
            });
        }
        if ((_10 = options.pullRequestTemplate) !== null && _10 !== void 0 ? _10 : true) {
            (_11 = this.github) === null || _11 === void 0 ? void 0 : _11.addPullRequestTemplate(...((_12 = options.pullRequestTemplateContents) !== null && _12 !== void 0 ? _12 : []));
        }
        const projenrcJs = (_13 = options.projenrcJs) !== null && _13 !== void 0 ? _13 : !options.projenrcJson;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
        // add a bundler component - this enables things like Lambda bundling and in the future web bundling.
        this.bundler = new bundler_1.Bundler(this, options.bundlerOptions);
        if ((_14 = options.package) !== null && _14 !== void 0 ? _14 : true) {
            this.packageTask.exec(`mkdir -p ${this.artifactsJavascriptDirectory}`);
            // always use npm here - yarn doesn't add much value
            // sadly we cannot use --pack-destination because it is not supported by older npm
            this.packageTask.exec(`mv $(npm pack) ${this.artifactsJavascriptDirectory}/`);
        }
        if ((_15 = options.prettier) !== null && _15 !== void 0 ? _15 : false) {
            this.prettier = new javascript_1.Prettier(this, { ...options.prettierOptions });
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() {
        return this.package.allowLibraryDependencies;
    }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() {
        return this.package.entrypoint;
    }
    /**
     * Minimum node.js version required by this package.
     */
    get minNodeVersion() {
        return this.package.minNodeVersion;
    }
    /**
     * Maximum node version required by this pacakge.
     */
    get maxNodeVersion() {
        return this.package.maxNodeVersion;
    }
    /**
     * The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() {
        return this.package.packageManager;
    }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * Replaces the contents of an npm package.json script.
     *
     * @param name The script name
     * @param command The command to execute
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * Removes the npm script (always successful).
     * @param name The name of the script.
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * Indicates if a script by the name name is defined.
     * @param name The name of the script
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * DEPRECATED
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * DEPRECATED
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * Directly set fields in `package.json`.
     * @param fields The fields to set
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * Adds keywords to package.json (deduplicated)
     * @param keywords The keywords to add
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * Returns the set of workflow steps which should be executed to bootstrap a
     * workflow.
     *
     * @param options Options.
     * @returns Job steps
     */
    renderWorkflowSetup(options = {}) {
        var _b;
        const install = new Array();
        // first run the workflow bootstrap steps
        install.push(...this.workflowBootstrapSteps);
        if (this.nodeVersion) {
            install.push({
                name: "Setup Node.js",
                uses: "actions/setup-node@v2.2.0",
                with: { "node-version": this.nodeVersion },
            });
        }
        if (this.package.packageManager === node_package_1.NodePackageManager.PNPM) {
            install.push({
                name: "Setup pnpm",
                uses: "pnpm/action-setup@v2.0.1",
                with: { version: "6.14.7" },
            });
        }
        const mutable = (_b = options.mutable) !== null && _b !== void 0 ? _b : false;
        install.push({
            name: "Install dependencies",
            run: mutable
                ? this.package.installAndUpdateLockfileCommand
                : this.package.installCommand,
        });
        return install;
    }
    /**
     * Defines normal dependencies.
     *
     * @param deps Names modules to install. By default, the the dependency will
     * be installed in the next `npx projen` run and the version will be recorded
     * in your `package.json` file. You can upgrade manually or using `yarn
     * add/upgrade`. If you wish to specify a version range use this syntax:
     * `module@^7`.
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * Defines development/test dependencies.
     *
     * @param deps Names modules to install. By default, the the dependency will
     * be installed in the next `npx projen` run and the version will be recorded
     * in your `package.json` file. You can upgrade manually or using `yarn
     * add/upgrade`. If you wish to specify a version range use this syntax:
     * `module@^7`.
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install. By default, the the dependency will
     * be installed in the next `npx projen` run and the version will be recorded
     * in your `package.json` file. You can upgrade manually or using `yarn
     * add/upgrade`. If you wish to specify a version range use this syntax:
     * `module@^7`.
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install. By default, the the dependency will
     * be installed in the next `npx projen` run and the version will be recorded
     * in your `package.json` file. You can upgrade manually or using `yarn
     * add/upgrade`. If you wish to specify a version range use this syntax:
     * `module@^7`.
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addPackageIgnore(pattern) {
        var _b;
        (_b = this.npmignore) === null || _b === void 0 ? void 0 : _b.addPatterns(pattern);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, {
                spdx: this.package.license,
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude("# Logs", "logs", "*.log", "npm-debug.log*", "yarn-debug.log*", "yarn-error.log*", "lerna-debug.log*", "# Diagnostic reports (https://nodejs.org/api/report.html)", "report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json", "# Runtime data", "pids", "*.pid", "*.seed", "*.pid.lock", "# Directory for instrumented libs generated by jscoverage/JSCover", "lib-cov", "# Coverage directory used by tools like istanbul", "coverage", "*.lcov", "# nyc test coverage", ".nyc_output", "# Compiled binary addons (https://nodejs.org/api/addons.html)", "build/Release", "# Dependency directories", "node_modules/", "jspm_packages/", "# TypeScript cache", "*.tsbuildinfo", "# Optional eslint cache", ".eslintcache", "# Output of 'npm pack'", "*.tgz", "# Yarn Integrity file", ".yarn-integrity", "# parcel-bundler cache (https://parceljs.org/)", ".cache");
    }
    /**
     * Returns the shell command to execute in order to run a task. This will
     * typically be `npx projen TASK`.
     *
     * @param task The task for which the command is required
     */
    runTaskCommand(task) {
        return `${this.package.projenCommand} ${task.name}`;
    }
    /**
     * The job ID of the build workflow.
     */
    get buildWorkflowJobId() {
        var _b;
        return (_b = this.buildWorkflow) === null || _b === void 0 ? void 0 : _b.buildJobIds[0];
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.javascript.NodeProject", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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