"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Prettier = exports.TrailingComma = exports.QuoteProps = exports.ProseWrap = exports.HTMLWhitespaceSensitivity = exports.EndOfLine = exports.EmbeddedLanguageFormatting = exports.ArrowParens = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ignore_file_1 = require("../ignore-file");
const json_1 = require("../json");
const source_code_1 = require("../source-code");
var ArrowParens;
(function (ArrowParens) {
    /**
     * Always include parens. Example: `(x) => x`
     */
    ArrowParens["ALWAYS"] = "always";
    /**
     * Omit parens when possible. Example: `x => x`
     */
    ArrowParens["AVOID"] = "avoid";
})(ArrowParens = exports.ArrowParens || (exports.ArrowParens = {}));
var EmbeddedLanguageFormatting;
(function (EmbeddedLanguageFormatting) {
    /**
     * Format embedded code if Prettier can automatically identify it.
     */
    EmbeddedLanguageFormatting["AUTO"] = "auto";
    /**
     * Never automatically format embedded code.
     */
    EmbeddedLanguageFormatting["OFF"] = "off";
})(EmbeddedLanguageFormatting = exports.EmbeddedLanguageFormatting || (exports.EmbeddedLanguageFormatting = {}));
var EndOfLine;
(function (EndOfLine) {
    /**
     * Maintain existing (mixed values within one file are normalised by looking
     * at what's used after the first line)
     */
    EndOfLine["AUTO"] = "auto";
    /**
     * Carriage Return character only (\r), used very rarely
     */
    EndOfLine["CR"] = "cr";
    /**
     * Carriage Return + Line Feed characters (\r\n), common on Windows
     */
    EndOfLine["CRLF"] = "crlf";
    /**
     * Line Feed only (\n), common on Linux and macOS as well as inside git repos
     */
    EndOfLine["LF"] = "lf";
})(EndOfLine = exports.EndOfLine || (exports.EndOfLine = {}));
var HTMLWhitespaceSensitivity;
(function (HTMLWhitespaceSensitivity) {
    /**
     * Respect the default value of CSS display property.
     */
    HTMLWhitespaceSensitivity["CSS"] = "css";
    /**
     * Whitespaces are considered insignificant.
     */
    HTMLWhitespaceSensitivity["IGNORE"] = "ignore";
    /**
     * Whitespaces are considered significant.
     */
    HTMLWhitespaceSensitivity["STRICT"] = "strict";
})(HTMLWhitespaceSensitivity = exports.HTMLWhitespaceSensitivity || (exports.HTMLWhitespaceSensitivity = {}));
var ProseWrap;
(function (ProseWrap) {
    /**
     * Wrap prose if it exceeds the print width.
     */
    ProseWrap["ALWAYS"] = "always";
    /**
     * Do not wrap prose.
     */
    ProseWrap["NEVER"] = "never";
    /**
     * Wrap prose as-is.
     */
    ProseWrap["PRESERVE"] = "preserve";
})(ProseWrap = exports.ProseWrap || (exports.ProseWrap = {}));
var QuoteProps;
(function (QuoteProps) {
    /**
     * Only add quotes around object properties where required.
     */
    QuoteProps["ASNEEDED"] = "as-needed";
    /**
     * If at least one property in an object requires quotes, quote all properties.
     */
    QuoteProps["CONSISTENT"] = "consistent";
    /**
     * Respect the input use of quotes in object properties.
     */
    QuoteProps["PRESERVE"] = "preserve";
})(QuoteProps = exports.QuoteProps || (exports.QuoteProps = {}));
var TrailingComma;
(function (TrailingComma) {
    /**
     * Trailing commas wherever possible (including function arguments).
     */
    TrailingComma["ALL"] = "all";
    /**
     * Trailing commas where valid in ES5 (objects, arrays, etc.)
     */
    TrailingComma["ES5"] = "es5";
    /**
     * No trailing commas.
     */
    TrailingComma["NONE"] = "none";
})(TrailingComma = exports.TrailingComma || (exports.TrailingComma = {}));
/**
 * Represents prettier configuration.
 */
class Prettier extends component_1.Component {
    constructor(project, options) {
        var _b, _c;
        super(project);
        this._overrides = (_b = options.overrides) !== null && _b !== void 0 ? _b : [];
        if ((_c = options.ignoreFile) !== null && _c !== void 0 ? _c : true) {
            this.ignoreFile = new ignore_file_1.IgnoreFile(project, ".prettierignore");
        }
        project.addDevDeps("prettier");
        this.settings = {
            ...options.settings,
        };
        new json_1.JsonFile(project, ".prettierrc.json", {
            obj: () => ({ ...this.settings, overrides: [...this._overrides] }),
            marker: false,
        });
    }
    static of(project) {
        const isPrettier = (c) => c instanceof Prettier;
        return project.components.find(isPrettier);
    }
    /**
     * Add a prettier override
     * @see https://prettier.io/docs/en/configuration.html#configuration-overrides
     * @param {PrettierOverride} override
     */
    addOverride(override) {
        this.overrides.push(override);
    }
    /**
     * Defines Prettier ignore Patterns
     * these patterns will be added to the file .prettierignore
     *
     * @param pattern filepatterns so exclude from prettier formatting
     */
    addIgnorePattern(pattern) {
        var _b;
        (_b = this.ignoreFile) === null || _b === void 0 ? void 0 : _b.addPatterns(pattern);
    }
    /**
     *  Access to the Prettieroverrides to extend those
     */
    get overrides() {
        return [...this._overrides];
    }
    preSynthesize() {
        // Add automatically generated SourceCode files to .prettierignore as they may not be formatted correctly.
        const isSourceCode = (c) => c instanceof source_code_1.SourceCode;
        this.project.components.filter(isSourceCode).forEach((c) => {
            this.addIgnorePattern(c.filePath);
        });
    }
}
exports.Prettier = Prettier;
_a = JSII_RTTI_SYMBOL_1;
Prettier[_a] = { fqn: "projen.javascript.Prettier", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJldHRpZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvamF2YXNjcmlwdC9wcmV0dGllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDRDQUF5QztBQUN6QyxnREFBNEM7QUFFNUMsa0NBQW1DO0FBRW5DLGdEQUE0QztBQW1NNUMsSUFBWSxXQVVYO0FBVkQsV0FBWSxXQUFXO0lBQ3JCOztPQUVHO0lBQ0gsZ0NBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCw4QkFBZSxDQUFBO0FBQ2pCLENBQUMsRUFWVyxXQUFXLEdBQVgsbUJBQVcsS0FBWCxtQkFBVyxRQVV0QjtBQUVELElBQVksMEJBVVg7QUFWRCxXQUFZLDBCQUEwQjtJQUNwQzs7T0FFRztJQUNILDJDQUFhLENBQUE7SUFFYjs7T0FFRztJQUNILHlDQUFXLENBQUE7QUFDYixDQUFDLEVBVlcsMEJBQTBCLEdBQTFCLGtDQUEwQixLQUExQixrQ0FBMEIsUUFVckM7QUFFRCxJQUFZLFNBcUJYO0FBckJELFdBQVksU0FBUztJQUNuQjs7O09BR0c7SUFDSCwwQkFBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCxzQkFBUyxDQUFBO0lBRVQ7O09BRUc7SUFDSCwwQkFBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCxzQkFBUyxDQUFBO0FBQ1gsQ0FBQyxFQXJCVyxTQUFTLEdBQVQsaUJBQVMsS0FBVCxpQkFBUyxRQXFCcEI7QUFFRCxJQUFZLHlCQWVYO0FBZkQsV0FBWSx5QkFBeUI7SUFDbkM7O09BRUc7SUFDSCx3Q0FBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw4Q0FBaUIsQ0FBQTtJQUVqQjs7T0FFRztJQUNILDhDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFmVyx5QkFBeUIsR0FBekIsaUNBQXlCLEtBQXpCLGlDQUF5QixRQWVwQztBQXdCRCxJQUFZLFNBZVg7QUFmRCxXQUFZLFNBQVM7SUFDbkI7O09BRUc7SUFDSCw4QkFBaUIsQ0FBQTtJQUVqQjs7T0FFRztJQUNILDRCQUFlLENBQUE7SUFFZjs7T0FFRztJQUNILGtDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFmVyxTQUFTLEdBQVQsaUJBQVMsS0FBVCxpQkFBUyxRQWVwQjtBQUVELElBQVksVUFlWDtBQWZELFdBQVksVUFBVTtJQUNwQjs7T0FFRztJQUNILG9DQUFzQixDQUFBO0lBRXRCOztPQUVHO0lBQ0gsdUNBQXlCLENBQUE7SUFFekI7O09BRUc7SUFDSCxtQ0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBZlcsVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUFlckI7QUFFRCxJQUFZLGFBZVg7QUFmRCxXQUFZLGFBQWE7SUFDdkI7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw4QkFBYSxDQUFBO0FBQ2YsQ0FBQyxFQWZXLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBZXhCO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLFFBQVMsU0FBUSxxQkFBUztJQXNCckMsWUFBWSxPQUFvQixFQUFFLE9BQXdCOztRQUN4RCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsVUFBVSxTQUFHLE9BQU8sQ0FBQyxTQUFTLG1DQUFJLEVBQUUsQ0FBQztRQUUxQyxVQUFJLE9BQU8sQ0FBQyxVQUFVLG1DQUFJLElBQUksRUFBRTtZQUM5QixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksd0JBQVUsQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztTQUM5RDtRQUVELE9BQU8sQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFL0IsSUFBSSxDQUFDLFFBQVEsR0FBRztZQUNkLEdBQUcsT0FBTyxDQUFDLFFBQVE7U0FDcEIsQ0FBQztRQUVGLElBQUksZUFBUSxDQUFDLE9BQU8sRUFBRSxrQkFBa0IsRUFBRTtZQUN4QyxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDO1lBQ2xFLE1BQU0sRUFBRSxLQUFLO1NBQ2QsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQXhDTSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQWdCO1FBQy9CLE1BQU0sVUFBVSxHQUFHLENBQUMsQ0FBWSxFQUFpQixFQUFFLENBQUMsQ0FBQyxZQUFZLFFBQVEsQ0FBQztRQUMxRSxPQUFPLE9BQU8sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUF1Q0Q7Ozs7T0FJRztJQUNJLFdBQVcsQ0FBQyxRQUEwQjtRQUMzQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxnQkFBZ0IsQ0FBQyxPQUFlOztRQUNyQyxNQUFBLElBQUksQ0FBQyxVQUFVLDBDQUFFLFdBQVcsQ0FBQyxPQUFPLEVBQUU7SUFDeEMsQ0FBQztJQUVEOztPQUVHO0lBQ0gsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sQ0FBQyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRU0sYUFBYTtRQUNsQiwwR0FBMEc7UUFDMUcsTUFBTSxZQUFZLEdBQUcsQ0FBQyxDQUFZLEVBQW1CLEVBQUUsQ0FDckQsQ0FBQyxZQUFZLHdCQUFVLENBQUM7UUFDMUIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO1lBQ3pELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDcEMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOztBQTVFSCw0QkE2RUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBJZ25vcmVGaWxlIH0gZnJvbSBcIi4uL2lnbm9yZS1maWxlXCI7XG5pbXBvcnQgeyBOb2RlUHJvamVjdCB9IGZyb20gXCIuLi9qYXZhc2NyaXB0XCI7XG5pbXBvcnQgeyBKc29uRmlsZSB9IGZyb20gXCIuLi9qc29uXCI7XG5pbXBvcnQgeyBQcm9qZWN0IH0gZnJvbSBcIi4uL3Byb2plY3RcIjtcbmltcG9ydCB7IFNvdXJjZUNvZGUgfSBmcm9tIFwiLi4vc291cmNlLWNvZGVcIjtcbi8qKlxuICogT3B0aW9ucyBmb3IgUHJldHRpZXJcbiAqXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUHJldHRpZXJPcHRpb25zIHtcbiAgLyoqXG4gICAqIERlZmluZXMgYW4gLnByZXR0aWVySWdub3JlIGZpbGVcbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgaWdub3JlRmlsZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFByZXR0aWVyIHNldHRpbmdzLlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgc2V0dGluZ3NcbiAgICovXG4gIHJlYWRvbmx5IHNldHRpbmdzPzogUHJldHRpZXJTZXR0aW5ncztcblxuICAvKipcbiAgICogUHJvdmlkZSBhIGxpc3Qgb2YgcGF0dGVybnMgdG8gb3ZlcnJpZGUgcHJldHRpZXIgY29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgW11cbiAgICogQHNlZSBodHRwczovL3ByZXR0aWVyLmlvL2RvY3MvZW4vY29uZmlndXJhdGlvbi5odG1sI2NvbmZpZ3VyYXRpb24tb3ZlcnJpZGVzXG4gICAqL1xuICByZWFkb25seSBvdmVycmlkZXM/OiBQcmV0dGllck92ZXJyaWRlW107XG59XG4vKipcbiAqIE9wdGlvbnMgdG8gc2V0IGluIFByZXR0aWVyIGRpcmVjdGx5IG9yIHRocm91Z2ggb3ZlcnJpZGVzXG4gKlxuICogQHNlZSBodHRwczovL3ByZXR0aWVyLmlvL2RvY3MvZW4vb3B0aW9ucy5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUHJldHRpZXJTZXR0aW5ncyB7XG4gIC8qKlxuICAgKiBJbmNsdWRlIHBhcmVudGhlc2VzIGFyb3VuZCBhIHNvbGUgYXJyb3cgZnVuY3Rpb24gcGFyYW1ldGVyLlxuICAgKlxuICAgKiBAZGVmYXVsdCBBcnJvd1BhcmVucy5BTFdBWVNcbiAgICovXG4gIHJlYWRvbmx5IGFycm93UGFyZW5zPzogQXJyb3dQYXJlbnM7XG4gIC8qKlxuICAgKiBQdXQgPiBvZiBvcGVuaW5nIHRhZ3Mgb24gdGhlIGxhc3QgbGluZSBpbnN0ZWFkIG9mIG9uIGEgbmV3IGxpbmUuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBicmFja2V0U2FtZUxpbmU/OiBib29sZWFuO1xuICAvKipcbiAgICogUHJpbnQgc3BhY2VzIGJldHdlZW4gYnJhY2tldHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGJyYWNrZXRTcGFjaW5nPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFByaW50ICh0byBzdGRlcnIpIHdoZXJlIGEgY3Vyc29yIGF0IHRoZSBnaXZlbiBwb3NpdGlvbiB3b3VsZCBtb3ZlIHRvIGFmdGVyIGZvcm1hdHRpbmcuXG4gICAqIFRoaXMgb3B0aW9uIGNhbm5vdCBiZSB1c2VkIHdpdGggLS1yYW5nZS1zdGFydCBhbmQgLS1yYW5nZS1lbmQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0xXG4gICAqL1xuICByZWFkb25seSBjdXJzb3JPZmZzZXQ/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBDb250cm9sIGhvdyBQcmV0dGllciBmb3JtYXRzIHF1b3RlZCBjb2RlIGVtYmVkZGVkIGluIHRoZSBmaWxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBFbWJlZGRlZExhbmd1YWdlRm9ybWF0dGluZy5BVVRPXG4gICAqL1xuICByZWFkb25seSBlbWJlZGRlZExhbmd1YWdlRm9ybWF0dGluZz86IEVtYmVkZGVkTGFuZ3VhZ2VGb3JtYXR0aW5nO1xuICAvKipcbiAgICogV2hpY2ggZW5kIG9mIGxpbmUgY2hhcmFjdGVycyB0byBhcHBseS5cbiAgICpcbiAgICogQGRlZmF1bHQgRW5kT2ZMaW5lLkxGXG4gICAqL1xuICByZWFkb25seSBlbmRPZkxpbmU/OiBFbmRPZkxpbmU7XG4gIC8qKlxuICAgKiBTcGVjaWZ5IHRoZSBpbnB1dCBmaWxlcGF0aC4gVGhpcyB3aWxsIGJlIHVzZWQgdG8gZG8gcGFyc2VyIGluZmVyZW5jZS5cbiAgICogQGRlZmF1bHQgbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZmlsZXBhdGg/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBIb3cgdG8gaGFuZGxlIHdoaXRlc3BhY2VzIGluIEhUTUwuXG4gICAqXG4gICAqIEBkZWZhdWx0IEhUTUxXaGl0ZXNwYWNlU2Vuc2l0aXZpdHkuQ1NTXG4gICAqL1xuICByZWFkb25seSBodG1sV2hpdGVzcGFjZVNlbnNpdGl2aXR5PzogSFRNTFdoaXRlc3BhY2VTZW5zaXRpdml0eTtcbiAgLyoqXG4gICAqIEluc2VydCBAZm9ybWF0IHByYWdtYSBpbnRvIGZpbGUncyBmaXJzdCBkb2NibG9jayBjb21tZW50LlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgaW5zZXJ0UHJhZ21hPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFVzZSBzaW5nbGUgcXVvdGVzIGluIEpTWC5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGpzeFNpbmdsZVF1b3RlPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFdoaWNoIHBhcnNlciB0byB1c2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gUHJldHRpZXIgYXV0b21hdGljYWxseSBpbmZlcnMgdGhlIHBhcnNlciBmcm9tIHRoZSBpbnB1dCBmaWxlIHBhdGgsIHNvIHlvdSBzaG91bGRu4oCZdCBoYXZlIHRvIGNoYW5nZSB0aGlzIHNldHRpbmcuXG4gICAqL1xuICByZWFkb25seSBwYXJzZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBZGQgYSBwbHVnaW4uIE11bHRpcGxlIHBsdWdpbnMgY2FuIGJlIHBhc3NlZCBhcyBzZXBhcmF0ZSBgLS1wbHVnaW5gcy5cbiAgICpcbiAgICogQGRlZmF1bHQgW11cbiAgICovXG4gIHJlYWRvbmx5IHBsdWdpbnM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICAqIEN1c3RvbSBkaXJlY3RvcnkgdGhhdCBjb250YWlucyBwcmV0dGllciBwbHVnaW5zIGluIG5vZGVfbW9kdWxlcyBzdWJkaXJlY3RvcnkuXG4gICAqIE92ZXJyaWRlcyBkZWZhdWx0IGJlaGF2aW9yIHdoZW4gcGx1Z2lucyBhcmUgc2VhcmNoZWQgcmVsYXRpdmVseSB0byB0aGUgbG9jYXRpb24gb2ZcbiAgICogUHJldHRpZXIuXG4gICAqIE11bHRpcGxlIHZhbHVlcyBhcmUgYWNjZXB0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IFtdXG4gICAqL1xuICByZWFkb25seSBwbHVnaW5TZWFyY2hEaXJzPzogc3RyaW5nW107XG4gIC8qKlxuICAgKiBUaGUgbGluZSBsZW5ndGggd2hlcmUgUHJldHRpZXIgd2lsbCB0cnkgd3JhcC5cbiAgICpcbiAgICogQGRlZmF1bHQgODBcbiAgICovXG4gIHJlYWRvbmx5IHByaW50V2lkdGg/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBIb3cgdG8gd3JhcCBwcm9zZS5cbiAgICpcbiAgICogQGRlZmF1bHQgUHJvc2VXcmFwLlBSRVNFUlZFXG4gICAqL1xuICByZWFkb25seSBwcm9zZVdyYXA/OiBQcm9zZVdyYXA7XG4gIC8qKlxuICAgKiBDaGFuZ2Ugd2hlbiBwcm9wZXJ0aWVzIGluIG9iamVjdHMgYXJlIHF1b3RlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgUXVvdGVQcm9wcy5BU05FRURFRFxuICAgKi9cbiAgcmVhZG9ubHkgcXVvdGVQcm9wcz86IFF1b3RlUHJvcHM7XG4gIC8qKlxuICAgKiBGb3JtYXQgY29kZSBlbmRpbmcgYXQgYSBnaXZlbiBjaGFyYWN0ZXIgb2Zmc2V0IChleGNsdXNpdmUpLlxuICAgKiBUaGUgcmFuZ2Ugd2lsbCBleHRlbmQgZm9yd2FyZHMgdG8gdGhlIGVuZCBvZiB0aGUgc2VsZWN0ZWQgc3RhdGVtZW50LlxuICAgKiBUaGlzIG9wdGlvbiBjYW5ub3QgYmUgdXNlZCB3aXRoIC0tY3Vyc29yLW9mZnNldC5cbiAgICpcbiAgICogQGRlZmF1bHQgbnVsbFxuICAgKi9cbiAgcmVhZG9ubHkgcmFuZ2VFbmQ/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBGb3JtYXQgY29kZSBzdGFydGluZyBhdCBhIGdpdmVuIGNoYXJhY3RlciBvZmZzZXQuXG4gICAqIFRoZSByYW5nZSB3aWxsIGV4dGVuZCBiYWNrd2FyZHMgdG8gdGhlIHN0YXJ0IG9mIHRoZSBmaXJzdCBsaW5lIGNvbnRhaW5pbmcgdGhlIHNlbGVjdGVkXG4gICAqIHN0YXRlbWVudC5cbiAgICogVGhpcyBvcHRpb24gY2Fubm90IGJlIHVzZWQgd2l0aCAtLWN1cnNvci1vZmZzZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IDBcbiAgICovXG4gIHJlYWRvbmx5IHJhbmdlU3RhcnQ/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBSZXF1aXJlIGVpdGhlciAnQHByZXR0aWVyJyBvciAnQGZvcm1hdCcgdG8gYmUgcHJlc2VudCBpbiB0aGUgZmlsZSdzIGZpcnN0IGRvY2Jsb2NrXG4gICAqIGNvbW1lbnRcbiAgICogaW4gb3JkZXIgZm9yIGl0IHRvIGJlIGZvcm1hdHRlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHJlcXVpcmVQcmFnbWE/OiBib29sZWFuO1xuICAvKipcbiAgICogUHJpbnQgc2VtaWNvbG9ucy5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgc2VtaT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBVc2Ugc2luZ2xlIHF1b3RlcyBpbnN0ZWFkIG9mIGRvdWJsZSBxdW90ZXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBzaW5nbGVRdW90ZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBOdW1iZXIgb2Ygc3BhY2VzIHBlciBpbmRlbnRhdGlvbiBsZXZlbC5cbiAgICpcbiAgICogQGRlZmF1bHQgMlxuICAgKi9cbiAgcmVhZG9ubHkgdGFiV2lkdGg/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBQcmludCB0cmFpbGluZyBjb21tYXMgd2hlcmV2ZXIgcG9zc2libGUgd2hlbiBtdWx0aS1saW5lLlxuICAgKlxuICAgKiBAZGVmYXVsdCBUcmFpbGluZ0NvbW1hLkVTNVxuICAgKi9cbiAgcmVhZG9ubHkgdHJhaWxpbmdDb21tYT86IFRyYWlsaW5nQ29tbWE7XG4gIC8qKlxuICAgKiBJbmRlbnQgd2l0aCB0YWJzIGluc3RlYWQgb2Ygc3BhY2VzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgdXNlVGFicz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBJbmRlbnQgc2NyaXB0IGFuZCBzdHlsZSB0YWdzIGluIFZ1ZSBmaWxlcy5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHZ1ZUluZGVudFNjcmlwdEFuZFN0eWxlPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGVudW0gQXJyb3dQYXJlbnMge1xuICAvKipcbiAgICogQWx3YXlzIGluY2x1ZGUgcGFyZW5zLiBFeGFtcGxlOiBgKHgpID0+IHhgXG4gICAqL1xuICBBTFdBWVMgPSBcImFsd2F5c1wiLFxuXG4gIC8qKlxuICAgKiBPbWl0IHBhcmVucyB3aGVuIHBvc3NpYmxlLiBFeGFtcGxlOiBgeCA9PiB4YFxuICAgKi9cbiAgQVZPSUQgPSBcImF2b2lkXCIsXG59XG5cbmV4cG9ydCBlbnVtIEVtYmVkZGVkTGFuZ3VhZ2VGb3JtYXR0aW5nIHtcbiAgLyoqXG4gICAqIEZvcm1hdCBlbWJlZGRlZCBjb2RlIGlmIFByZXR0aWVyIGNhbiBhdXRvbWF0aWNhbGx5IGlkZW50aWZ5IGl0LlxuICAgKi9cbiAgQVVUTyA9IFwiYXV0b1wiLFxuXG4gIC8qKlxuICAgKiBOZXZlciBhdXRvbWF0aWNhbGx5IGZvcm1hdCBlbWJlZGRlZCBjb2RlLlxuICAgKi9cbiAgT0ZGID0gXCJvZmZcIixcbn1cblxuZXhwb3J0IGVudW0gRW5kT2ZMaW5lIHtcbiAgLyoqXG4gICAqIE1haW50YWluIGV4aXN0aW5nIChtaXhlZCB2YWx1ZXMgd2l0aGluIG9uZSBmaWxlIGFyZSBub3JtYWxpc2VkIGJ5IGxvb2tpbmdcbiAgICogYXQgd2hhdCdzIHVzZWQgYWZ0ZXIgdGhlIGZpcnN0IGxpbmUpXG4gICAqL1xuICBBVVRPID0gXCJhdXRvXCIsXG5cbiAgLyoqXG4gICAqIENhcnJpYWdlIFJldHVybiBjaGFyYWN0ZXIgb25seSAoXFxyKSwgdXNlZCB2ZXJ5IHJhcmVseVxuICAgKi9cbiAgQ1IgPSBcImNyXCIsXG5cbiAgLyoqXG4gICAqIENhcnJpYWdlIFJldHVybiArIExpbmUgRmVlZCBjaGFyYWN0ZXJzIChcXHJcXG4pLCBjb21tb24gb24gV2luZG93c1xuICAgKi9cbiAgQ1JMRiA9IFwiY3JsZlwiLFxuXG4gIC8qKlxuICAgKiBMaW5lIEZlZWQgb25seSAoXFxuKSwgY29tbW9uIG9uIExpbnV4IGFuZCBtYWNPUyBhcyB3ZWxsIGFzIGluc2lkZSBnaXQgcmVwb3NcbiAgICovXG4gIExGID0gXCJsZlwiLFxufVxuXG5leHBvcnQgZW51bSBIVE1MV2hpdGVzcGFjZVNlbnNpdGl2aXR5IHtcbiAgLyoqXG4gICAqIFJlc3BlY3QgdGhlIGRlZmF1bHQgdmFsdWUgb2YgQ1NTIGRpc3BsYXkgcHJvcGVydHkuXG4gICAqL1xuICBDU1MgPSBcImNzc1wiLFxuXG4gIC8qKlxuICAgKiBXaGl0ZXNwYWNlcyBhcmUgY29uc2lkZXJlZCBpbnNpZ25pZmljYW50LlxuICAgKi9cbiAgSUdOT1JFID0gXCJpZ25vcmVcIixcblxuICAvKipcbiAgICogV2hpdGVzcGFjZXMgYXJlIGNvbnNpZGVyZWQgc2lnbmlmaWNhbnQuXG4gICAqL1xuICBTVFJJQ1QgPSBcInN0cmljdFwiLFxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFByZXR0aWVyT3ZlcnJpZGUge1xuICAvKipcbiAgICogRXhjbHVkZSB0aGVzZSBmaWxlcyBmcm9tIHRoaXMgb3ZlcnJpZGUuXG4gICAqL1xuICByZWFkb25seSBleGNsdWRlRmlsZXM/OiBGaWxlcztcbiAgLyoqXG4gICAqIEluY2x1ZGUgdGhlc2UgZmlsZXMgaW4gdGhpcyBvdmVycmlkZS5cbiAgICovXG4gIHJlYWRvbmx5IGZpbGVzOiBGaWxlcztcbiAgLyoqXG4gICAqIFRoZSBvcHRpb25zIHRvIGFwcGx5IGZvciB0aGlzIG92ZXJyaWRlLlxuICAgKi9cbiAgcmVhZG9ubHkgc2V0dGluZ3M6IFByZXR0aWVyU2V0dGluZ3M7XG59XG5cbi8qKlxuICogRXhjbHVkZSB0aGVzZSBmaWxlcyBmcm9tIHRoaXMgb3ZlcnJpZGUuXG4gKlxuICogSW5jbHVkZSB0aGVzZSBmaWxlcyBpbiB0aGlzIG92ZXJyaWRlLlxuICovXG5leHBvcnQgdHlwZSBGaWxlcyA9IHN0cmluZ1tdIHwgc3RyaW5nO1xuXG5leHBvcnQgZW51bSBQcm9zZVdyYXAge1xuICAvKipcbiAgICogV3JhcCBwcm9zZSBpZiBpdCBleGNlZWRzIHRoZSBwcmludCB3aWR0aC5cbiAgICovXG4gIEFMV0FZUyA9IFwiYWx3YXlzXCIsXG5cbiAgLyoqXG4gICAqIERvIG5vdCB3cmFwIHByb3NlLlxuICAgKi9cbiAgTkVWRVIgPSBcIm5ldmVyXCIsXG5cbiAgLyoqXG4gICAqIFdyYXAgcHJvc2UgYXMtaXMuXG4gICAqL1xuICBQUkVTRVJWRSA9IFwicHJlc2VydmVcIixcbn1cblxuZXhwb3J0IGVudW0gUXVvdGVQcm9wcyB7XG4gIC8qKlxuICAgKiBPbmx5IGFkZCBxdW90ZXMgYXJvdW5kIG9iamVjdCBwcm9wZXJ0aWVzIHdoZXJlIHJlcXVpcmVkLlxuICAgKi9cbiAgQVNORUVERUQgPSBcImFzLW5lZWRlZFwiLFxuXG4gIC8qKlxuICAgKiBJZiBhdCBsZWFzdCBvbmUgcHJvcGVydHkgaW4gYW4gb2JqZWN0IHJlcXVpcmVzIHF1b3RlcywgcXVvdGUgYWxsIHByb3BlcnRpZXMuXG4gICAqL1xuICBDT05TSVNURU5UID0gXCJjb25zaXN0ZW50XCIsXG5cbiAgLyoqXG4gICAqIFJlc3BlY3QgdGhlIGlucHV0IHVzZSBvZiBxdW90ZXMgaW4gb2JqZWN0IHByb3BlcnRpZXMuXG4gICAqL1xuICBQUkVTRVJWRSA9IFwicHJlc2VydmVcIixcbn1cblxuZXhwb3J0IGVudW0gVHJhaWxpbmdDb21tYSB7XG4gIC8qKlxuICAgKiBUcmFpbGluZyBjb21tYXMgd2hlcmV2ZXIgcG9zc2libGUgKGluY2x1ZGluZyBmdW5jdGlvbiBhcmd1bWVudHMpLlxuICAgKi9cbiAgQUxMID0gXCJhbGxcIixcblxuICAvKipcbiAgICogVHJhaWxpbmcgY29tbWFzIHdoZXJlIHZhbGlkIGluIEVTNSAob2JqZWN0cywgYXJyYXlzLCBldGMuKVxuICAgKi9cbiAgRVM1ID0gXCJlczVcIixcblxuICAvKipcbiAgICogTm8gdHJhaWxpbmcgY29tbWFzLlxuICAgKi9cbiAgTk9ORSA9IFwibm9uZVwiLFxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgcHJldHRpZXIgY29uZmlndXJhdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIFByZXR0aWVyIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHVibGljIHN0YXRpYyBvZihwcm9qZWN0OiBQcm9qZWN0KTogUHJldHRpZXIgfCB1bmRlZmluZWQge1xuICAgIGNvbnN0IGlzUHJldHRpZXIgPSAoYzogQ29tcG9uZW50KTogYyBpcyBQcmV0dGllciA9PiBjIGluc3RhbmNlb2YgUHJldHRpZXI7XG4gICAgcmV0dXJuIHByb2plY3QuY29tcG9uZW50cy5maW5kKGlzUHJldHRpZXIpO1xuICB9XG4gIC8qKlxuICAgKiBEaXJlY3QgYWNjZXNzIHRvIHRoZSBwcmV0dGllciBzZXR0aW5nc1xuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHNldHRpbmdzOiBQcmV0dGllclNldHRpbmdzO1xuXG4gIC8qKlxuICAgKiBUaGUgLnByZXR0aWVySWdub3JlIGZpbGUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgaWdub3JlRmlsZT86IElnbm9yZUZpbGU7XG5cbiAgLyoqXG4gICAqIERpcmVjdCBhY2Nlc3MgdG8gdGhlIHByZXR0aWVyIG92ZXJyaWRlc1xuICAgKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgX292ZXJyaWRlczogUHJldHRpZXJPdmVycmlkZVtdO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0LCBvcHRpb25zOiBQcmV0dGllck9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcblxuICAgIHRoaXMuX292ZXJyaWRlcyA9IG9wdGlvbnMub3ZlcnJpZGVzID8/IFtdO1xuXG4gICAgaWYgKG9wdGlvbnMuaWdub3JlRmlsZSA/PyB0cnVlKSB7XG4gICAgICB0aGlzLmlnbm9yZUZpbGUgPSBuZXcgSWdub3JlRmlsZShwcm9qZWN0LCBcIi5wcmV0dGllcmlnbm9yZVwiKTtcbiAgICB9XG5cbiAgICBwcm9qZWN0LmFkZERldkRlcHMoXCJwcmV0dGllclwiKTtcblxuICAgIHRoaXMuc2V0dGluZ3MgPSB7XG4gICAgICAuLi5vcHRpb25zLnNldHRpbmdzLFxuICAgIH07XG5cbiAgICBuZXcgSnNvbkZpbGUocHJvamVjdCwgXCIucHJldHRpZXJyYy5qc29uXCIsIHtcbiAgICAgIG9iajogKCkgPT4gKHsgLi4udGhpcy5zZXR0aW5ncywgb3ZlcnJpZGVzOiBbLi4udGhpcy5fb3ZlcnJpZGVzXSB9KSxcbiAgICAgIG1hcmtlcjogZmFsc2UsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQWRkIGEgcHJldHRpZXIgb3ZlcnJpZGVcbiAgICogQHNlZSBodHRwczovL3ByZXR0aWVyLmlvL2RvY3MvZW4vY29uZmlndXJhdGlvbi5odG1sI2NvbmZpZ3VyYXRpb24tb3ZlcnJpZGVzXG4gICAqIEBwYXJhbSB7UHJldHRpZXJPdmVycmlkZX0gb3ZlcnJpZGVcbiAgICovXG4gIHB1YmxpYyBhZGRPdmVycmlkZShvdmVycmlkZTogUHJldHRpZXJPdmVycmlkZSkge1xuICAgIHRoaXMub3ZlcnJpZGVzLnB1c2gob3ZlcnJpZGUpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmluZXMgUHJldHRpZXIgaWdub3JlIFBhdHRlcm5zXG4gICAqIHRoZXNlIHBhdHRlcm5zIHdpbGwgYmUgYWRkZWQgdG8gdGhlIGZpbGUgLnByZXR0aWVyaWdub3JlXG4gICAqXG4gICAqIEBwYXJhbSBwYXR0ZXJuIGZpbGVwYXR0ZXJucyBzbyBleGNsdWRlIGZyb20gcHJldHRpZXIgZm9ybWF0dGluZ1xuICAgKi9cbiAgcHVibGljIGFkZElnbm9yZVBhdHRlcm4ocGF0dGVybjogc3RyaW5nKSB7XG4gICAgdGhpcy5pZ25vcmVGaWxlPy5hZGRQYXR0ZXJucyhwYXR0ZXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiAgQWNjZXNzIHRvIHRoZSBQcmV0dGllcm92ZXJyaWRlcyB0byBleHRlbmQgdGhvc2VcbiAgICovXG4gIHB1YmxpYyBnZXQgb3ZlcnJpZGVzKCkge1xuICAgIHJldHVybiBbLi4udGhpcy5fb3ZlcnJpZGVzXTtcbiAgfVxuXG4gIHB1YmxpYyBwcmVTeW50aGVzaXplKCkge1xuICAgIC8vIEFkZCBhdXRvbWF0aWNhbGx5IGdlbmVyYXRlZCBTb3VyY2VDb2RlIGZpbGVzIHRvIC5wcmV0dGllcmlnbm9yZSBhcyB0aGV5IG1heSBub3QgYmUgZm9ybWF0dGVkIGNvcnJlY3RseS5cbiAgICBjb25zdCBpc1NvdXJjZUNvZGUgPSAoYzogQ29tcG9uZW50KTogYyBpcyBTb3VyY2VDb2RlID0+XG4gICAgICBjIGluc3RhbmNlb2YgU291cmNlQ29kZTtcbiAgICB0aGlzLnByb2plY3QuY29tcG9uZW50cy5maWx0ZXIoaXNTb3VyY2VDb2RlKS5mb3JFYWNoKChjKSA9PiB7XG4gICAgICB0aGlzLmFkZElnbm9yZVBhdHRlcm4oYy5maWxlUGF0aCk7XG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==