"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptConfig = exports.TypeScriptJsxMode = exports.TypeScriptModuleResolution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
/**
 * Determines how modules get resolved.
 *
 * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html
 */
var TypeScriptModuleResolution;
(function (TypeScriptModuleResolution) {
    /**
     * TypeScript's former default resolution strategy.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#classic
     */
    TypeScriptModuleResolution["CLASSIC"] = "classic";
    /**
     * Resolution strategy which attempts to mimic the Node.js module resolution strategy at runtime.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#node
     */
    TypeScriptModuleResolution["NODE"] = "node";
})(TypeScriptModuleResolution = exports.TypeScriptModuleResolution || (exports.TypeScriptModuleResolution = {}));
/**
 * Determines how JSX should get transformed into valid JavaScript.
 *
 * @see https://www.typescriptlang.org/docs/handbook/jsx.html
 */
var TypeScriptJsxMode;
(function (TypeScriptJsxMode) {
    /**
     * Keeps the JSX as part of the output to be further consumed by another transform step (e.g. Babel).
     */
    TypeScriptJsxMode["PRESERVE"] = "preserve";
    /**
     * Converts JSX syntax into React.createElement, does not need to go through a JSX transformation before use, and the output will have a .js file extension.
     */
    TypeScriptJsxMode["REACT"] = "react";
    /**
     * Keeps all JSX like 'preserve' mode, but output will have a .js extension.
     */
    TypeScriptJsxMode["REACT_NATIVE"] = "react-native";
    /**
     * Passes `key` separately from props and always passes `children` as props (since React 17).
     *
     * @see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-1.html#react-17-jsx-factories
     */
    TypeScriptJsxMode["REACT_JSX"] = "react-jsx";
    /**
     * Same as `REACT_JSX` with additional debug data.
     */
    TypeScriptJsxMode["REACT_JSXDEV"] = "react-jsxdev";
})(TypeScriptJsxMode = exports.TypeScriptJsxMode || (exports.TypeScriptJsxMode = {}));
class TypescriptConfig {
    constructor(project, options) {
        var _b, _c, _d, _e;
        const fileName = (_b = options.fileName) !== null && _b !== void 0 ? _b : "tsconfig.json";
        this.include = (_c = options.include) !== null && _c !== void 0 ? _c : ["**/*.ts"];
        this.exclude = (_d = options.exclude) !== null && _d !== void 0 ? _d : ["node_modules"];
        this.fileName = fileName;
        this.compilerOptions = options.compilerOptions;
        this.file = new json_1.JsonFile(project, fileName, {
            obj: {
                compilerOptions: this.compilerOptions,
                include: () => this.include,
                exclude: () => this.exclude,
            },
        });
        (_e = project.npmignore) === null || _e === void 0 ? void 0 : _e.exclude(`/${fileName}`);
    }
    addInclude(pattern) {
        this.include.push(pattern);
    }
    addExclude(pattern) {
        this.exclude.push(pattern);
    }
}
exports.TypescriptConfig = TypescriptConfig;
_a = JSII_RTTI_SYMBOL_1;
TypescriptConfig[_a] = { fqn: "projen.javascript.TypescriptConfig", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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