"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBundleName = void 0;
const path_1 = require("path");
function renderBundleName(entrypoint) {
    const parts = path_1.join(entrypoint).split(path_1.sep);
    if (parts[0] === "src") {
        parts.shift(); // just remove 'src' if its the first element for ergonomics
    }
    const p = parts.join(path_1.sep);
    const dir = path_1.dirname(p);
    const base = path_1.basename(p, path_1.extname(p));
    return path_1.join(dir, base);
}
exports.renderBundleName = renderBundleName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9qYXZhc2NyaXB0L3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQTZEO0FBRTdELFNBQWdCLGdCQUFnQixDQUFDLFVBQWtCO0lBQ2pELE1BQU0sS0FBSyxHQUFHLFdBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBRyxDQUFDLENBQUM7SUFDMUMsSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssS0FBSyxFQUFFO1FBQ3RCLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLDREQUE0RDtLQUM1RTtJQUVELE1BQU0sQ0FBQyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsVUFBRyxDQUFDLENBQUM7SUFDMUIsTUFBTSxHQUFHLEdBQUcsY0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3ZCLE1BQU0sSUFBSSxHQUFHLGVBQVEsQ0FBQyxDQUFDLEVBQUUsY0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDckMsT0FBTyxXQUFJLENBQUMsR0FBRyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3pCLENBQUM7QUFWRCw0Q0FVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGJhc2VuYW1lLCBkaXJuYW1lLCBleHRuYW1lLCBqb2luLCBzZXAgfSBmcm9tIFwicGF0aFwiO1xuXG5leHBvcnQgZnVuY3Rpb24gcmVuZGVyQnVuZGxlTmFtZShlbnRyeXBvaW50OiBzdHJpbmcpIHtcbiAgY29uc3QgcGFydHMgPSBqb2luKGVudHJ5cG9pbnQpLnNwbGl0KHNlcCk7XG4gIGlmIChwYXJ0c1swXSA9PT0gXCJzcmNcIikge1xuICAgIHBhcnRzLnNoaWZ0KCk7IC8vIGp1c3QgcmVtb3ZlICdzcmMnIGlmIGl0cyB0aGUgZmlyc3QgZWxlbWVudCBmb3IgZXJnb25vbWljc1xuICB9XG5cbiAgY29uc3QgcCA9IHBhcnRzLmpvaW4oc2VwKTtcbiAgY29uc3QgZGlyID0gZGlybmFtZShwKTtcbiAgY29uc3QgYmFzZSA9IGJhc2VuYW1lKHAsIGV4dG5hbWUocCkpO1xuICByZXR1cm4gam9pbihkaXIsIGJhc2UpO1xufVxuIl19