"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const object_file_1 = require("./object-file");
/**
 * Represents a JSON file.
 */
class JsonFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options) {
        var _b;
        super(project, filePath, options);
        this.newline = (_b = options.newline) !== null && _b !== void 0 ? _b : true;
        if (!options.obj) {
            throw new Error('"obj" cannot be undefined');
        }
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        const sanitized = JSON.parse(json);
        if (this.marker) {
            sanitized["//"] = this.marker;
        }
        let content = JSON.stringify(sanitized, undefined, 2);
        if (this.newline) {
            content += "\n";
        }
        return content;
    }
}
exports.JsonFile = JsonFile;
_a = JSII_RTTI_SYMBOL_1;
JsonFile[_a] = { fqn: "projen.JsonFile", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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