"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.License = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs-extra");
const file_1 = require("./file");
class License extends file_1.FileBase {
    constructor(project, options) {
        var _b;
        super(project, "LICENSE", { marker: false });
        const spdx = options.spdx;
        const textFile = `${__dirname}/../license-text/${spdx}.txt`;
        if (!fs.existsSync(textFile)) {
            throw new Error(`unsupported license ${spdx}`);
        }
        const years = (_b = options.copyrightPeriod) !== null && _b !== void 0 ? _b : new Date().getFullYear().toString();
        const owner = options.copyrightOwner;
        let text = fs.readFileSync(textFile, "utf-8");
        text = text.replace("$copyright_period", years);
        // if the license text includes $copyright_owner, then `copyrightOwner` is required.
        if (text.indexOf("$copyright_owner") !== -1) {
            if (!owner) {
                throw new Error(`The ${spdx} license requires "copyrightOwner" to be specified`);
            }
            text = text.replace("$copyright_owner", owner);
        }
        this.text = text;
    }
    synthesizeContent(_) {
        return this.text;
    }
}
exports.License = License;
_a = JSII_RTTI_SYMBOL_1;
License[_a] = { fqn: "projen.License", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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