"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const vm = require("vm");
const inventory_1 = require("./inventory");
const render_options_1 = require("./javascript/render-options");
const option_hints_1 = require("./option-hints");
/**
 * Programmatic API for projen.
 */
class Projects {
    constructor() { }
    /**
     * Creates a new project with defaults.
     *
     * This function creates the project type in-process (with in VM) and calls
     * `.synth()` on it (if `options.synth` is not `false`).
     *
     * At the moment, it also generates a `.projenrc.js` file with the same code
     * that was just executed. In the future, this will also be done by the project
     * type, so we can easily support multiple languages of projenrc.
     */
    static createProject(options) {
        createProject(options);
    }
}
exports.Projects = Projects;
_a = JSII_RTTI_SYMBOL_1;
Projects[_a] = { fqn: "projen.Projects", version: "0.52.53" };
function createProject(opts) {
    var _b, _c, _d;
    const projectType = inventory_1.resolveProjectType(opts.projectFqn);
    // Default project resolution location
    let mod = "./index";
    // External projects need to load the module from the modules directory
    if (projectType.moduleName !== "projen") {
        try {
            mod = path.dirname(require.resolve(path.join(projectType.moduleName, "package.json"), {
                paths: [process.cwd()],
            }));
        }
        catch (err) {
            throw new Error(`External project module '${projectType.moduleName}' could not be resolved.`);
        }
    }
    // "dir" is exposed as a top-level option to require users to specify a value for it
    opts.projectOptions.outdir = opts.dir;
    // pass the FQN of the project type to the project initializer so it can
    // generate the projenrc file.
    const { renderedOptions } = render_options_1.renderJavaScriptOptions({
        bootstrap: true,
        comments: (_b = opts.optionHints) !== null && _b !== void 0 ? _b : option_hints_1.InitProjectOptionHints.FEATURED,
        type: projectType,
        args: opts.projectOptions,
        omitFromBootstrap: ["outdir"],
    });
    // generate a random variable name because jest tests appear to share
    // VM contexts, causing
    //
    // > SyntaxError: Identifier 'project' has already been declared
    //
    // errors if this isn't unique
    const varName = "project" + Math.random().toString(36).slice(2);
    const initProjectCode = `const ${varName} = new ${projectType.typename}(${renderedOptions});`;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const module = require(mod);
    const ctx = vm.createContext(module);
    const synth = (_c = opts.synth) !== null && _c !== void 0 ? _c : true;
    const postSynth = (_d = opts.post) !== null && _d !== void 0 ? _d : true;
    process.env.PROJEN_DISABLE_POST = (!postSynth).toString();
    vm.runInContext([initProjectCode, synth ? `${varName}.synth();` : ""].join("\n"), ctx);
}
//# sourceMappingURL=data:application/json;base64,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