"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("./component");
/**
 * Sets up a project to use JSON for projenrc.
 */
class Projenrc extends component_1.Component {
    constructor(project, options = {}) {
        var _b, _c, _d;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : ".projenrc.json";
        // this is the task projen executes when running `projen`
        (_c = project.defaultTask) === null || _c === void 0 ? void 0 : _c.env("FILENAME", this.rcfile);
        (_d = project.defaultTask) === null || _d === void 0 ? void 0 : _d.builtin("run-projenrc-json");
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const json = {
            type: bootstrap.fqn,
            ...bootstrap.args,
        };
        fs_1.writeFileSync(rcfile, JSON.stringify(json, null, 2));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.Projenrc", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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