"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pip = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const task_runtime_1 = require("../task-runtime");
const requirements_file_1 = require("./requirements-file");
/**
 * Manages dependencies using a requirements.txt file and the pip CLI tool.
 */
class Pip extends component_1.Component {
    constructor(project, _options = {}) {
        super(project);
        new requirements_file_1.RequirementsFile(project, "requirements.txt", {
            packageProvider: new RuntimeDependencyProvider(project),
        });
        new requirements_file_1.RequirementsFile(project, "requirements-dev.txt", {
            packageProvider: new DevDependencyProvider(project),
        });
        this.installTask = project.addTask("install", {
            description: "Install and upgrade dependencies",
        });
        this.installTask.exec("pip install --upgrade pip");
        this.installTask.exec("pip install -r requirements.txt");
        this.installTask.exec("pip install -r requirements-dev.txt");
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.RUNTIME);
    }
    /**
     * Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.DEVENV);
    }
    /**
     * Installs dependencies (called during post-synthesis).
     */
    installDependencies() {
        this.project.logger.info("Installing dependencies...");
        const runtime = new task_runtime_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.Pip = Pip;
_a = JSII_RTTI_SYMBOL_1;
Pip[_a] = { fqn: "projen.python.Pip", version: "0.52.53" };
class RuntimeDependencyProvider {
    constructor(pythonProject) {
        this.pythonProject = pythonProject;
    }
    get packages() {
        return this.pythonProject.deps.all.filter((dep) => dep.type === dependencies_1.DependencyType.RUNTIME);
    }
}
class DevDependencyProvider {
    constructor(pythonProject) {
        this.pythonProject = pythonProject;
    }
    get packages() {
        return this.pythonProject.deps.all.filter((dep) => dep.type === dependencies_1.DependencyType.DEVENV);
    }
}
//# sourceMappingURL=data:application/json;base64,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