"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const github_1 = require("../github");
const project_1 = require("../project");
const pip_1 = require("./pip");
const poetry_1 = require("./poetry");
const projenrc_1 = require("./projenrc");
const pytest_1 = require("./pytest");
const pytest_sample_1 = require("./pytest-sample");
const python_sample_1 = require("./python-sample");
const setuptools_1 = require("./setuptools");
const venv_1 = require("./venv");
/** Allowed characters in python project names */
const PYTHON_PROJECT_NAME_REGEX = /^[A-Za-z0-9-_\.]+$/;
/**
 * Python project.
 *
 * @pjid python
 */
class PythonProject extends github_1.GitHubProject {
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
        super(options);
        if (!PYTHON_PROJECT_NAME_REGEX.test(options.name)) {
            throw new Error("Python projects must only consist of alphanumeric characters, hyphens, and underscores.");
        }
        this.moduleName = options.moduleName;
        this.version = options.version;
        if ((_b = options.projenrcPython) !== null && _b !== void 0 ? _b : true) {
            new projenrc_1.Projenrc(this, options.projenrcPythonOptions);
        }
        if ((_c = options.venv) !== null && _c !== void 0 ? _c : true) {
            this.envManager = new venv_1.Venv(this, options.venvOptions);
        }
        if ((_d = options.pip) !== null && _d !== void 0 ? _d : true) {
            this.depsManager = new pip_1.Pip(this);
        }
        if ((_e = options.setuptools) !== null && _e !== void 0 ? _e : this.projectType === project_1.ProjectType.LIB) {
            this.packagingManager = new setuptools_1.Setuptools(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                setupConfig: options.setupConfig,
            });
        }
        // if (options.conda ?? false) {
        //   this.depsManager = new Conda(this, options);
        //   this.envManager = this.depsManager;
        // }
        // if (options.pipenv ?? false) {
        //   this.depsManager = new Pipenv(this, options);
        //   this.envManager = this.depsManager;
        // }
        if ((_f = options.poetry) !== null && _f !== void 0 ? _f : false) {
            const poetry = new poetry_1.Poetry(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                poetryOptions: {
                    readme: (_h = (_g = options.readme) === null || _g === void 0 ? void 0 : _g.filename) !== null && _h !== void 0 ? _h : "README.md",
                    ...options.poetryOptions,
                },
            });
            this.depsManager = poetry;
            this.envManager = poetry;
            this.packagingManager = poetry;
        }
        if (!this.envManager) {
            throw new Error("At least one tool must be chosen for managing the environment (venv, conda, pipenv, or poetry).");
        }
        if (!this.depsManager) {
            throw new Error("At least one tool must be chosen for managing dependencies (pip, conda, pipenv, or poetry).");
        }
        if (!this.packagingManager && this.projectType === project_1.ProjectType.LIB) {
            throw new Error("At least one tool must be chosen for managing packaging (setuptools or poetry).");
        }
        if (Number((_j = options.venv) !== null && _j !== void 0 ? _j : true) + Number((_k = options.poetry) !== null && _k !== void 0 ? _k : false) > 1) {
            throw new Error("More than one component has been chosen for managing the environment (venv, conda, pipenv, or poetry)");
        }
        if (Number((_l = options.pip) !== null && _l !== void 0 ? _l : true) + Number((_m = options.poetry) !== null && _m !== void 0 ? _m : false) > 1) {
            throw new Error("More than one component has been chosen for managing dependencies (pip, conda, pipenv, or poetry)");
        }
        if (Number((_o = options.setuptools) !== null && _o !== void 0 ? _o : true) + Number((_p = options.poetry) !== null && _p !== void 0 ? _p : false) >
            1) {
            throw new Error("More than one component has been chosen for managing packaging (setuptools or poetry)");
        }
        if ((_q = options.pytest) !== null && _q !== void 0 ? _q : true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
            new pytest_sample_1.PytestSample(this, this.pytest.testdir);
        }
        if ((_r = options.sample) !== null && _r !== void 0 ? _r : true) {
            new python_sample_1.PythonSample(this, {});
        }
        for (const dep of (_s = options.deps) !== null && _s !== void 0 ? _s : []) {
            this.addDependency(dep);
        }
        for (const dep of (_t = options.devDeps) !== null && _t !== void 0 ? _t : []) {
            this.addDevDependency(dep);
        }
        this.addDefaultGitIgnore();
    }
    /**
     * Adds default gitignore options for a Python project based on
     * https://github.com/github/gitignore/blob/master/Python.gitignore
     */
    addDefaultGitIgnore() {
        this.gitignore.exclude("# Byte-compiled / optimized / DLL files", "__pycache__/", "*.py[cod]", "*$py.class", "", "# C extensions", "*.so", "", "# Distribution / packaging", ".Python", "build/", "develop-eggs/", "dist/", "downloads/", "eggs/", ".eggs/", "lib/", "lib64/", "parts/", "sdist/", "var/", "wheels/", "share/python-wheels/", "*.egg-info/", ".installed.cfg", "*.egg", "MANIFEST", "", "# PyInstaller", "#  Usually these files are written by a python script from a template", "#  before PyInstaller builds the exe, so as to inject date/other infos into it.", "*.manifest", "*.spec", "", "# Installer logs", "pip-log.txt", "pip-delete-this-directory.txt", "", "# Unit test / coverage reports", "htmlcov/", ".tox/", ".nox/", ".coverage", ".coverage.*", ".cache", "nosetests.xml", "coverage.xml", "*.cover", "*.py,cover", ".hypothesis/", ".pytest_cache/", "cover/", "", "# Translations", "*.mo", "*.pot", "", "# Django stuff:", "*.log", "local_settings.py", "db.sqlite3", "db.sqlite3-journal", "", "# Flask stuff:", "instance/", ".webassets-cache", "", "# Scrapy stuff:", ".scrapy", "", "# Sphinx documentation", "docs/_build/", "", "# PyBuilder", ".pybuilder/", "target/", "", "# Jupyter Notebook", ".ipynb_checkpoints", "", "# IPython", "profile_default/", "ipython_config.py", "", "# PEP 582; used by e.g. github.com/David-OConnor/pyflow", "__pypackages__/", "", "# Celery stuff", "celerybeat-schedule", "celerybeat.pid", "", "# SageMath parsed files", "*.sage.py", "", "# Environments", ".env", ".venv", "env/", "venv/", "ENV/", "env.bak/", "venv.bak/", "", "# Spyder project settings", ".spyderproject", ".spyproject", "", "# Rope project settings", ".ropeproject", "", "# mkdocs documentation", "/site", "", "# mypy", ".mypy_cache/", ".dmypy.json", "dmypy.json", "", "# Pyre type checker", ".pyre/", "", "# pytype static type analyzer", ".pytype/", "", "# Cython debug symbols", "cython_debug/");
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDependency(spec) {
        return this.depsManager.addDependency(spec);
    }
    /**
     * Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDevDependency(spec) {
        return this.depsManager.addDevDependency(spec);
    }
    postSynthesize() {
        super.postSynthesize();
        this.envManager.setupEnvironment();
        this.depsManager.installDependencies();
    }
}
exports.PythonProject = PythonProject;
_a = JSII_RTTI_SYMBOL_1;
PythonProject[_a] = { fqn: "projen.python.PythonProject", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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