"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonSample = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
/**
 * Python code sample.
 */
class PythonSample extends component_1.Component {
    constructor(project, _options) {
        super(project);
        new sample_file_1.SampleDir(project, project.moduleName, {
            files: {
                "__init__.py": '__version__ = "0.1.0"\n',
                "__main__.py": [
                    "from .example import hello",
                    "",
                    'if __name__ == "__main__":',
                    '    name = input("What is your name? ")',
                    "    print(hello(name))",
                    "",
                ].join("\n"),
                "example.py": [
                    "def hello(name: str) -> str:",
                    '    """A simple greeting.',
                    "    Args:",
                    "        name (str): Name to greet.",
                    "    Returns:",
                    "        str: greeting message",
                    '    """',
                    '    return f"Hello {name}!"',
                    "",
                ].join("\n"),
            },
        });
    }
}
exports.PythonSample = PythonSample;
_a = JSII_RTTI_SYMBOL_1;
PythonSample[_a] = { fqn: "projen.python.PythonSample", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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