"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * Python packaging script where package metadata can be placed.
 */
class SetupPy extends file_1.FileBase {
    constructor(project, options) {
        super(project, "setup.py");
        this.setupConfig = {
            name: project.name,
            packages: [project.moduleName],
            python_requires: ">=3.6",
            classifiers: [
                "Intended Audience :: Developers",
                "Programming Language :: Python :: 3 :: Only",
                "Programming Language :: Python :: 3.6",
                "Programming Language :: Python :: 3.7",
                "Programming Language :: Python :: 3.8",
                "Programming Language :: Python :: 3.9",
            ],
            ...(options ? this.renameFields(options) : []),
        };
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            "import json",
            "from setuptools import setup",
            "",
            "kwargs = json.loads(",
            '    """',
            JSON.stringify(this.setupConfig, null, 4),
            '"""',
            ")",
            "",
            "setup(**kwargs)",
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
    // modify some key names since JSII interfaces require fields to be camelCase
    renameFields(options) {
        const obj = {};
        for (const [key, value] of Object.entries(options)) {
            if (key === "authorName") {
                obj.author = value;
            }
            else if (key === "authorEmail") {
                obj.author_email = value;
            }
            else if (key === "homepage") {
                obj.url = value;
            }
            else {
                obj[key] = value;
            }
        }
        return obj;
    }
}
exports.SetupPy = SetupPy;
_a = JSII_RTTI_SYMBOL_1;
SetupPy[_a] = { fqn: "projen.python.SetupPy", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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