"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Setuptools = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const setuppy_1 = require("./setuppy");
/**
 * Manages packaging through setuptools with a setup.py script.
 */
class Setuptools extends component_1.Component {
    constructor(project, options) {
        super(project);
        project.addDevDependency("wheel@0.36.2");
        project.addDevDependency("twine@3.3.0");
        project.packageTask.exec("python setup.py sdist bdist_wheel");
        this.publishTestTask = project.addTask("publish:test", {
            description: "Uploads the package against a test PyPI endpoint.",
            exec: "twine upload --repository-url https://test.pypi.org/legacy/ dist/*",
        });
        this.publishTask = project.addTask("publish", {
            description: "Uploads the package against a test PyPI endpoint.",
            exec: "twine upload dist/*",
        });
        new setuppy_1.SetupPy(project, {
            name: project.name,
            packages: [project.moduleName],
            authorName: options.authorName,
            authorEmail: options.authorEmail,
            version: options.version,
            description: options.description,
            license: options.license,
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.setupConfig,
        });
    }
}
exports.Setuptools = Setuptools;
_a = JSII_RTTI_SYMBOL_1;
Setuptools[_a] = { fqn: "projen.python.Setuptools", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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