import { Component } from "../component";
import { IPythonEnv } from "./python-env";
import { PythonProject } from "./python-project";
/**
 * Options for venv.
 */
export interface VenvOptions {
    /**
     * Name of directory to store the environment in
     *
     * @default ".env"
     */
    readonly envdir?: string;
}
/**
 * Manages a virtual environment through the Python venv module.
 */
export declare class Venv extends Component implements IPythonEnv {
    /**
     * Name of directory to store the environment in
     */
    private readonly envdir;
    constructor(project: PythonProject, options?: VenvOptions);
    /**
     * Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     */
    setupEnvironment(): void;
}
