"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to manage release strategies. This includes release
 * and release artifact automation
 */
class ReleaseTrigger {
    constructor(options = {}) {
        var _b;
        this.isContinuous = (_b = options.continuous) !== null && _b !== void 0 ? _b : false;
        this.schedule = options.schedule;
        this.changelogPath = options.changelogPath;
        this.gitPushCommand = options.gitPushCommand;
    }
    /**
     * Creates a manual release trigger.
     *
     * Use this option if you want totally manual releases.
     *
     * This will give you a release task that, in addition to the normal
     * release activities will trigger a `publish:git` task. This task will
     * handle project-level changelog management, release tagging, and pushing
     * these artifacts to origin.
     *
     * The command used for pushing can be customised by specifying
     * `gitPushCommand`. Set to an empty string to disable pushing entirely.
     *
     * Simply run `yarn release` to trigger a manual release.
     *
     * @param options release options
     */
    static manual(options = {}) {
        var _b, _c;
        let changelogPath;
        if ((_b = options.changelog) !== null && _b !== void 0 ? _b : true) {
            changelogPath = (_c = options.changelogPath) !== null && _c !== void 0 ? _c : "CHANGELOG.md";
        }
        return new ReleaseTrigger({
            changelogPath: changelogPath,
            gitPushCommand: options.gitPushCommand,
        });
    }
    /**
     * Creates a scheduled release trigger.
     *
     * Automated releases will occur based on the provided cron schedule.
     *
     * @param options release options.
     */
    static scheduled(options) {
        return new ReleaseTrigger({
            schedule: options.schedule,
        });
    }
    /**
     * Creates a continuous release trigger.
     *
     * Automated releases will occur on every commit.
     */
    static continuous() {
        return new ReleaseTrigger({
            continuous: true,
        });
    }
    /**
     * Whether or not this is a manual release trigger.
     */
    get isManual() {
        return !(this.isContinuous || this.schedule);
    }
}
exports.ReleaseTrigger = ReleaseTrigger;
_a = JSII_RTTI_SYMBOL_1;
ReleaseTrigger[_a] = { fqn: "projen.release.ReleaseTrigger", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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