"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parses a projenrc.json file, uses it to generate a corresponding
 * projenrc.js file, and then run it to synthesize its contents.
 *
 * Environment variables:
 *
 * - PROJENRC_FILE: (optional) the name of the JSON file to parse from.
 *   Defaults to `.projenrc.json`.
 */
const fs = require("fs-extra");
const option_hints_1 = require("./option-hints");
const projects_1 = require("./projects");
let filename = process.env.PROJENRC_FILE;
if (!filename || filename == "") {
    filename = ".projenrc.json";
}
const { type, ...json } = fs.readJsonSync(filename, { encoding: "utf8" });
if (!type) {
    throw new Error('projenrc.json requires a "type" field with the fully qualified type name. e.g. projen.web.ReactProject');
}
projects_1.Projects.createProject({
    dir: ".",
    projectFqn: type,
    projectOptions: json,
    optionHints: option_hints_1.InitProjectOptionHints.NONE,
    synth: true,
    post: false,
});
//# sourceMappingURL=data:application/json;base64,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