"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Semver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
/**
 * @deprecated This class will be removed in upcoming releases. if you wish to
 * specify semver requirements in `deps`, `devDeps`, etc, specify them like so
 * `express@^2.1`.
 */
class Semver {
    constructor(spec) {
        this.spec = spec;
    }
    static of(spec) {
        return new Semver(spec);
    }
    /**
     * Latest version.
     */
    static latest() {
        return new Semver("*");
    }
    /**
     * Accept only an exact version
     */
    static pinned(version) {
        return new Semver(version);
    }
    /**
     * Accept any minor version.
     *
     * >= version
     * < next major version
     */
    static caret(version) {
        return new Semver(`^${version}`);
    }
    /**
     * Accept patches.
     *
     * >= version
     * < next minor version
     */
    static tilde(version) {
        return new Semver(`~${version}`);
    }
    get version() {
        var _b;
        return (_b = semver.minVersion(this.spec)) === null || _b === void 0 ? void 0 : _b.version;
    }
}
exports.Semver = Semver;
_a = JSII_RTTI_SYMBOL_1;
Semver[_a] = { fqn: "projen.Semver", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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