"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const textfile_1 = require("./textfile");
/**
 * Represents a source file.
 */
class SourceCode extends component_1.Component {
    constructor(project, filePath, options = {}) {
        var _b;
        super(project);
        this.filePath = filePath;
        this.indentLevel = 0;
        this.indent = (_b = options.indent) !== null && _b !== void 0 ? _b : 2;
        this.file = new textfile_1.TextFile(project, filePath);
    }
    get marker() {
        return this.file.marker;
    }
    /**
     * Emit a line of code.
     * @param code The contents, if not specified, just adds a newline
     */
    line(code) {
        const spaces = this.indent * this.indentLevel;
        const prefix = " ".repeat(spaces);
        this.file.addLine((prefix + (code !== null && code !== void 0 ? code : "")).trimEnd());
    }
    /**
     * Opens a code block and increases the indentation level.
     *
     * @param code The code before the block starts (e.g. `export class {`).
     */
    open(code) {
        if (code) {
            this.line(code);
        }
        this.indentLevel++;
    }
    /**
     * Decreases the indentation level and closes a code block.
     *
     * @param code The code after the block is closed (e.g. `}`).
     */
    close(code) {
        if (this.indentLevel === 0) {
            throw new Error("Cannot decrease indent level below zero");
        }
        this.indentLevel--;
        if (code) {
            this.line(code);
        }
    }
}
exports.SourceCode = SourceCode;
_a = JSII_RTTI_SYMBOL_1;
SourceCode[_a] = { fqn: "projen.SourceCode", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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