"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Testing = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const synth_1 = require("./util/synth");
/**
 * A Testing static class with a .synth helper for getting a snapshots of construct outputs.
 * Useful for snapshot testing with Jest.
 *
 * @example `expect(Testing.synth(someProject)).toMatchSnapshot()`
 */
class Testing {
    constructor() { } // utility
    /**
     * Produces a simple JS object that represents the contents of the projects with field names being file paths.
     * @param project the project to produce a snapshot for
     * @return { [filename:string]: any }
     */
    static synth(project) {
        return synth_1.synthSnapshot(project);
    }
}
exports.Testing = Testing;
_a = JSII_RTTI_SYMBOL_1;
Testing[_a] = { fqn: "projen.Testing", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy90ZXN0aW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esd0NBQTZDO0FBRTdDOzs7OztHQUtHO0FBQ0gsTUFBYSxPQUFPO0lBVWxCLGdCQUF1QixDQUFDLENBQUMsVUFBVTtJQVRuQzs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFnQjtRQUNsQyxPQUFPLHFCQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDaEMsQ0FBQzs7QUFSSCwwQkFXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFByb2plY3QgfSBmcm9tIFwiLi9wcm9qZWN0XCI7XG5pbXBvcnQgeyBzeW50aFNuYXBzaG90IH0gZnJvbSBcIi4vdXRpbC9zeW50aFwiO1xuXG4vKipcbiAqIEEgVGVzdGluZyBzdGF0aWMgY2xhc3Mgd2l0aCBhIC5zeW50aCBoZWxwZXIgZm9yIGdldHRpbmcgYSBzbmFwc2hvdHMgb2YgY29uc3RydWN0IG91dHB1dHMuXG4gKiBVc2VmdWwgZm9yIHNuYXBzaG90IHRlc3Rpbmcgd2l0aCBKZXN0LlxuICpcbiAqIEBleGFtcGxlIGBleHBlY3QoVGVzdGluZy5zeW50aChzb21lUHJvamVjdCkpLnRvTWF0Y2hTbmFwc2hvdCgpYFxuICovXG5leHBvcnQgY2xhc3MgVGVzdGluZyB7XG4gIC8qKlxuICAgKiBQcm9kdWNlcyBhIHNpbXBsZSBKUyBvYmplY3QgdGhhdCByZXByZXNlbnRzIHRoZSBjb250ZW50cyBvZiB0aGUgcHJvamVjdHMgd2l0aCBmaWVsZCBuYW1lcyBiZWluZyBmaWxlIHBhdGhzLlxuICAgKiBAcGFyYW0gcHJvamVjdCB0aGUgcHJvamVjdCB0byBwcm9kdWNlIGEgc25hcHNob3QgZm9yXG4gICAqIEByZXR1cm4geyBbZmlsZW5hbWU6c3RyaW5nXTogYW55IH1cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgc3ludGgocHJvamVjdDogUHJvamVjdCk6IFJlY29yZDxzdHJpbmcsIGFueT4ge1xuICAgIHJldHVybiBzeW50aFNuYXBzaG90KHByb2plY3QpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHt9IC8vIHV0aWxpdHlcbn1cbiJdfQ==