"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * A text file.
 */
class TextFile extends file_1.FileBase {
    /**
     * Defines a text file.
     *
     * @param project The project
     * @param filePath File path
     * @param options Options
     */
    constructor(project, filePath, options = {}) {
        var _b;
        super(project, filePath, options);
        this.lines = (_b = options.lines) !== null && _b !== void 0 ? _b : [];
    }
    /**
     * Adds a line to the text file.
     * @param line the line to add (can use tokens)
     */
    addLine(line) {
        this.lines.push(line);
    }
    synthesizeContent(_) {
        return this.lines.join("\n");
    }
}
exports.TextFile = TextFile;
_a = JSII_RTTI_SYMBOL_1;
TextFile[_a] = { fqn: "projen.TextFile", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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