"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
class Projenrc extends component_1.Component {
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : ".projenrc.ts";
        const projensrc = (_c = options.projenCodeDir) !== null && _c !== void 0 ? _c : "projenrc";
        // tell eslint to take .projenrc.ts and *.ts files under `projen` into account as a dev-dependency
        project.tsconfigDev.addInclude(this.rcfile);
        (_d = project.eslint) === null || _d === void 0 ? void 0 : _d.allowDevDeps(this.rcfile);
        (_e = project.eslint) === null || _e === void 0 ? void 0 : _e.addIgnorePattern(`!${this.rcfile}`);
        project.tsconfigDev.addInclude(`${projensrc}/**/*.ts`);
        (_f = project.eslint) === null || _f === void 0 ? void 0 : _f.allowDevDeps(`${projensrc}/**/*.ts`);
        (_g = project.eslint) === null || _g === void 0 ? void 0 : _g.addIgnorePattern(`!${projensrc}/**/*.ts`);
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps("ts-node@^9");
        // we use "tsconfig.dev.json" here to allow projen source files to reside
        // anywhere in the project tree.
        (_h = project.defaultTask) === null || _h === void 0 ? void 0 : _h.exec(`ts-node --project ${project.tsconfigDev.fileName} ${this.rcfile}`);
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(importName);
        const lines = new Array();
        lines.push(`import { ${[...imports].sort().join(", ")} } from "${moduleName}";`);
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        fs_1.writeFileSync(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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